/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

public enum MidHashType {
    SHA256("SHA-256", "SHA256", 256, new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32}),
    SHA384("SHA-384", "SHA384", 384, new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48}),
    SHA512("SHA-512", "SHA512", 512, new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64});

    private String algorithmName;
    private String hashTypeName;
    private int lengthInBits;
    private byte[] digestInfoPrefix;

    private MidHashType(String algorithmName, String hashTypeName, int lengthInBits, byte[] digestInfoPrefix) {
        this.algorithmName = algorithmName;
        this.hashTypeName = hashTypeName;
        this.lengthInBits = lengthInBits;
        this.digestInfoPrefix = digestInfoPrefix;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getHashTypeName() {
        return this.hashTypeName;
    }

    public int getLengthInBytes() {
        return this.lengthInBits / 8;
    }

    public byte[] getDigestInfoPrefix() {
        return Arrays.copyOf(this.digestInfoPrefix, this.digestInfoPrefix.length);
    }

    public byte[] calculateDigest(byte[] dataToDigest) {
        return DigestUtils.getDigest((String)this.algorithmName).digest(dataToDigest);
    }
}

