/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.MidNationalIdentificationCodeValidator;
import ee.sk.mid.exception.MidInvalidNationalIdentityNumberException;
import ee.sk.mid.exception.MidInvalidPhoneNumberException;

public class MidInputUtil {
    public static boolean isPhoneNumberValid(String phoneNumber) {
        return phoneNumber != null && phoneNumber.matches("^\\+\\d{8,30}");
    }

    public static boolean isNationalIdentityNumberValid(String nationalIdentityNumber) {
        return MidNationalIdentificationCodeValidator.isValid(nationalIdentityNumber);
    }

    public static void validatePhoneNumber(String phoneNumber) {
        if (!MidInputUtil.isPhoneNumberValid(phoneNumber)) {
            throw new MidInvalidPhoneNumberException(phoneNumber);
        }
    }

    public static void validateNationalIdentityNumber(String nationalIdentityNumber) {
        if (!MidInputUtil.isNationalIdentityNumberValid(nationalIdentityNumber)) {
            throw new MidInvalidNationalIdentityNumberException(nationalIdentityNumber);
        }
    }

    public static String getValidatedPhoneNumber(String phoneNumberInput) {
        String cleanedPhoneNumber = phoneNumberInput.replaceAll("\\s", "");
        MidInputUtil.validatePhoneNumber(cleanedPhoneNumber);
        return cleanedPhoneNumber;
    }

    public static String getValidatedNationalIdentityNumber(String nationalIdentityNumber) {
        String cleanedNationalIdentityNumber = nationalIdentityNumber.replaceAll("\\s", "");
        MidInputUtil.validateNationalIdentityNumber(cleanedNationalIdentityNumber);
        return cleanedNationalIdentityNumber;
    }
}

