/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.exception.MidInternalErrorException;
import org.apache.commons.codec.binary.Base64;

public class MidSignature {
    private String valueInBase64;
    private String algorithmName;

    public byte[] getValue() {
        return Base64.decodeBase64((String)this.valueInBase64);
    }

    private MidSignature(MobileIdSignatureBuilder builder) {
        this.valueInBase64 = builder.valueInBase64;
        this.algorithmName = builder.algorithmName;
        if (!Base64.isBase64((String)this.valueInBase64)) {
            throw new MidInternalErrorException("Returned signature value is not a base64 string.");
        }
    }

    public String getValueInBase64() {
        return this.valueInBase64;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public static MobileIdSignatureBuilder newBuilder() {
        return new MobileIdSignatureBuilder();
    }

    public static class MobileIdSignatureBuilder {
        private String valueInBase64;
        private String algorithmName;

        private MobileIdSignatureBuilder() {
        }

        public MobileIdSignatureBuilder withValueInBase64(String valueInBase64) {
            this.valueInBase64 = valueInBase64;
            return this;
        }

        public MobileIdSignatureBuilder withAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public MidSignature build() {
            return new MidSignature(this);
        }
    }
}

