/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.MidAuthentication;
import ee.sk.mid.exception.MidInternalErrorException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidSignatureVerifier {
    private static final Logger logger = LoggerFactory.getLogger(MidSignatureVerifier.class);

    public static boolean verifyWithRSA(PublicKey signersPublicKey, MidAuthentication authentication) {
        try {
            Signature signature = Signature.getInstance("NONEwithRSA");
            signature.initVerify(signersPublicKey);
            byte[] signedHash = Base64.decodeBase64((String)authentication.getSignedHashInBase64());
            byte[] signedDigest = MidSignatureVerifier.addPadding(authentication.getHashType().getDigestInfoPrefix(), signedHash);
            signature.update(signedDigest);
            return signature.verify(authentication.getSignatureValue());
        }
        catch (GeneralSecurityException e) {
            logger.error("Signature verification with RSA failed");
            throw new MidInternalErrorException("Signature verification with RSA failed", e);
        }
    }

    private static byte[] addPadding(byte[] digestInfoPrefix, byte[] digest) {
        return ArrayUtils.addAll((byte[])digestInfoPrefix, (byte[])digest);
    }

    public static boolean verifyWithECDSA(PublicKey signersPublicKey, MidAuthentication authentication) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Signature signature = Signature.getInstance("NONEwithECDSA", "BC");
            signature.initVerify(signersPublicKey);
            byte[] signedDigest = Base64.decodeBase64((String)authentication.getSignedHashInBase64());
            signature.update(signedDigest);
            return signature.verify(MidSignatureVerifier.fromCVCEncoding(authentication.getSignatureValue()));
        }
        catch (GeneralSecurityException e) {
            logger.error("Signature verification with ECDSA failed");
            throw new MidInternalErrorException("Signature verification with ECDSA failed", e);
        }
    }

    private static byte[] fromCVCEncoding(byte[] cvcEncoding) {
        byte[][] elements = MidSignatureVerifier.splitArrayInTheMiddle(cvcEncoding);
        BigInteger r = new BigInteger(1, elements[0]);
        BigInteger s = new BigInteger(1, elements[1]);
        return MidSignatureVerifier.encodeInAsn1(r, s);
    }

    private static byte[][] splitArrayInTheMiddle(byte[] array) {
        return new byte[][]{ArrayUtils.subarray((byte[])array, (int)0, (int)(array.length / 2)), ArrayUtils.subarray((byte[])array, (int)(array.length / 2), (int)array.length)};
    }

    private static byte[] encodeInAsn1(BigInteger r, BigInteger s) {
        ASN1EncodableVector sequence = new ASN1EncodableVector();
        sequence.add((ASN1Encodable)new ASN1Integer(r));
        sequence.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(sequence).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

