/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid;

import ee.sk.mid.exception.MidSslException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class MidTrustUtil {
    public static KeyStore createTrustStore(List<String> trustedCertificates) {
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, "".toCharArray());
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            int i = 0;
            for (String sslCertificate : trustedCertificates) {
                Certificate certificate = factory.generateCertificate(new ByteArrayInputStream(sslCertificate.getBytes(StandardCharsets.UTF_8)));
                trustStore.setCertificateEntry("mid_api_ssl_cert" + ++i, certificate);
            }
            return trustStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new MidSslException(e.getMessage());
        }
    }

    public static SSLContext createSslContext(KeyStore trustStore) {
        try {
            SSLContext sslTrustContext = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
            trustManagerFactory.init(trustStore);
            sslTrustContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslTrustContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new MidSslException(e.getMessage());
        }
    }
}

