/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid.rest;

import ee.sk.mid.rest.MidLoggingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.message.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidLoggingFilter
implements ClientRequestFilter,
ClientResponseFilter,
WriterInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(MidLoggingFilter.class);
    private static final String LOGGING_OUTPUT_STREAM_PROPERTY = "loggingOutputStream";

    public void filter(ClientRequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            this.logUrl(requestContext);
        }
        if (logger.isTraceEnabled()) {
            this.logHeaders(requestContext);
            if (requestContext.hasEntity()) {
                this.wrapEntityStreamWithLogger(requestContext);
            }
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Response status: " + responseContext.getStatus() + " - " + responseContext.getStatusInfo());
        }
        if (logger.isTraceEnabled() && responseContext.hasEntity()) {
            this.logResponseBody(responseContext);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        context.proceed();
        if (logger.isTraceEnabled()) {
            this.logRequestBody(context);
        }
    }

    private void logUrl(ClientRequestContext requestContext) {
        String method = requestContext.getMethod();
        URI uri = requestContext.getUri();
        logger.debug(method + " " + uri.toString());
    }

    private void logHeaders(ClientRequestContext requestContext) {
        MultivaluedMap headers = requestContext.getStringHeaders();
        if (headers != null) {
            logger.trace("Request headers: " + headers.toString());
        }
    }

    private void wrapEntityStreamWithLogger(ClientRequestContext requestContext) {
        OutputStream entityStream = requestContext.getEntityStream();
        MidLoggingOutputStream loggingOutputStream = new MidLoggingOutputStream(entityStream);
        requestContext.setEntityStream((OutputStream)loggingOutputStream);
        requestContext.setProperty(LOGGING_OUTPUT_STREAM_PROPERTY, (Object)loggingOutputStream);
    }

    private void logResponseBody(ClientResponseContext responseContext) throws IOException {
        Charset charset = MessageUtils.getCharset((MediaType)responseContext.getMediaType());
        InputStream entityStream = responseContext.getEntityStream();
        byte[] bodyBytes = this.readInputStreamBytes(entityStream);
        responseContext.setEntityStream((InputStream)new ByteArrayInputStream(bodyBytes));
        logger.trace("Response body: " + new String(bodyBytes, charset));
    }

    private byte[] readInputStreamBytes(InputStream entityStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = entityStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toByteArray();
    }

    private void logRequestBody(WriterInterceptorContext context) {
        MidLoggingOutputStream loggingOutputStream = (MidLoggingOutputStream)context.getProperty(LOGGING_OUTPUT_STREAM_PROPERTY);
        if (loggingOutputStream != null) {
            Charset charset = MessageUtils.getCharset((MediaType)context.getMediaType());
            byte[] bytes = loggingOutputStream.getBytes();
            logger.trace("Message body: " + new String(bytes, charset));
        }
    }
}

