/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid.rest;

import com.fasterxml.jackson.databind.JsonNode;
import ee.sk.mid.exception.MidException;
import ee.sk.mid.exception.MidInternalErrorException;
import ee.sk.mid.exception.MidMissingOrInvalidParameterException;
import ee.sk.mid.exception.MidServiceUnavailableException;
import ee.sk.mid.exception.MidSessionNotFoundException;
import ee.sk.mid.exception.MidUnauthorizedException;
import ee.sk.mid.rest.MidConnector;
import ee.sk.mid.rest.MidLoggingFilter;
import ee.sk.mid.rest.MidRestConnectorBuilder;
import ee.sk.mid.rest.dao.MidSessionStatus;
import ee.sk.mid.rest.dao.request.MidAbstractRequest;
import ee.sk.mid.rest.dao.request.MidAuthenticationRequest;
import ee.sk.mid.rest.dao.request.MidCertificateRequest;
import ee.sk.mid.rest.dao.request.MidSessionStatusRequest;
import ee.sk.mid.rest.dao.request.MidSignatureRequest;
import ee.sk.mid.rest.dao.response.MidAuthenticationResponse;
import ee.sk.mid.rest.dao.response.MidCertificateChoiceResponse;
import ee.sk.mid.rest.dao.response.MidSignatureResponse;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidRestConnector
implements MidConnector {
    private static final Logger logger = LoggerFactory.getLogger(MidRestConnector.class);
    private static final String CERTIFICATE_PATH = "/certificate";
    private static final String SIGNATURE_PATH = "/signature";
    private static final String AUTHENTICATION_PATH = "/authentication";
    private String endpointUrl;
    private Configuration clientConfig;
    private Client configuredClient;
    private String relyingPartyUUID;
    private String relyingPartyName;
    private SSLContext trustSslContext;

    public MidRestConnector(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public MidRestConnector(String endpointUrl, Configuration clientConfig) {
        this(endpointUrl);
        this.clientConfig = clientConfig;
    }

    public MidRestConnector(String endpointUrl, Configuration clientConfig, String relyingPartyUUID, String relyingPartyName) {
        this.endpointUrl = endpointUrl;
        this.clientConfig = clientConfig;
        this.relyingPartyName = relyingPartyName;
        this.relyingPartyUUID = relyingPartyUUID;
    }

    MidRestConnector(MidRestConnectorBuilder mobileIdRestConnectorBuilder) {
        this.endpointUrl = mobileIdRestConnectorBuilder.endpointUrl;
        this.clientConfig = mobileIdRestConnectorBuilder.clientConfig;
        this.configuredClient = mobileIdRestConnectorBuilder.configuredClient;
        this.relyingPartyName = mobileIdRestConnectorBuilder.relyingPartyName;
        this.relyingPartyUUID = mobileIdRestConnectorBuilder.relyingPartyUUID;
        this.trustSslContext = mobileIdRestConnectorBuilder.sslContext;
    }

    @Override
    public MidCertificateChoiceResponse getCertificate(MidCertificateRequest request) {
        this.setRequestRelyingPartyDetailsIfMissing(request);
        logger.debug("Getting certificate for phone number: " + request.getPhoneNumber());
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(CERTIFICATE_PATH).build(new Object[0]);
        return this.postCertificateRequest(uri, request);
    }

    @Override
    public MidSignatureResponse sign(MidSignatureRequest request) {
        this.setRequestRelyingPartyDetailsIfMissing(request);
        logger.debug("Signing for phone number: " + request.getPhoneNumber());
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(SIGNATURE_PATH).build(new Object[0]);
        return this.postSignatureRequest(uri, request);
    }

    @Override
    public MidAuthenticationResponse authenticate(MidAuthenticationRequest request) {
        this.setRequestRelyingPartyDetailsIfMissing(request);
        logger.debug("Authenticating for phone number " + request.getPhoneNumber());
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(AUTHENTICATION_PATH).build(new Object[0]);
        return this.postAuthenticationRequest(uri, request);
    }

    private void setRequestRelyingPartyDetailsIfMissing(MidAbstractRequest request) {
        if (request.getRelyingPartyUUID() == null) {
            request.setRelyingPartyUUID(this.relyingPartyUUID);
        }
        if (request.getRelyingPartyName() == null) {
            request.setRelyingPartyName(this.relyingPartyName);
        }
        if (StringUtils.isBlank((CharSequence)request.getRelyingPartyUUID())) {
            throw new MidMissingOrInvalidParameterException("Relying Party UUID parameter must be set in client or request");
        }
        if (StringUtils.isBlank((CharSequence)request.getRelyingPartyName())) {
            throw new MidMissingOrInvalidParameterException("Relying Party Name parameter must be set in client or request");
        }
    }

    @Override
    public MidSessionStatus getAuthenticationSessionStatus(MidSessionStatusRequest request) throws MidSessionNotFoundException {
        return this.getSessionStatus(request, "/authentication/session/{sessionId}");
    }

    @Override
    public MidSessionStatus getSignatureSessionStatus(MidSessionStatusRequest request) {
        return this.getSessionStatus(request, "/signature/session/{sessionId}");
    }

    @Override
    public MidSessionStatus getSessionStatus(MidSessionStatusRequest request, String path) throws MidSessionNotFoundException {
        logger.debug("Getting session status for " + request.getSessionID());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.endpointUrl).path(path);
        if (request.getTimeoutMs() != 0) {
            uriBuilder.queryParam("timeoutMs", new Object[]{request.getTimeoutMs()});
        }
        URI uri = uriBuilder.build(new Object[]{request.getSessionID()});
        try {
            return (MidSessionStatus)this.prepareClient(uri).get(MidSessionStatus.class);
        }
        catch (NotFoundException e) {
            logger.error("Session " + request + " not found: " + e.getMessage());
            throw new MidSessionNotFoundException();
        }
    }

    private MidCertificateChoiceResponse postCertificateRequest(URI uri, MidCertificateRequest request) {
        return this.postRequest(uri, request, MidCertificateChoiceResponse.class);
    }

    private MidSignatureResponse postSignatureRequest(URI uri, MidSignatureRequest request) {
        return this.postRequest(uri, request, MidSignatureResponse.class);
    }

    private MidAuthenticationResponse postAuthenticationRequest(URI uri, MidAuthenticationRequest request) {
        return this.postRequest(uri, request, MidAuthenticationResponse.class);
    }

    private <T, V> T postRequest(URI uri, V request, Class<T> responseType) throws MidException {
        try {
            Entity requestEntity = Entity.entity(request, (String)"application/json");
            return (T)this.prepareClient(uri).post(requestEntity, responseType);
        }
        catch (InternalServerErrorException e) {
            logger.error("Error getting response from cert-store/MSSP for URI " + uri + ": " + e.getMessage());
            throw new MidInternalErrorException("Error getting response from cert-store/MSSP for URI " + uri + ": " + e.getMessage());
        }
        catch (NotFoundException e) {
            logger.error("Response not found for URI " + uri + ": " + e.getMessage());
            throw new MidInternalErrorException("MID internal error");
        }
        catch (BadRequestException e) {
            String errorMessage = this.readErrorMessageFromBody(e);
            logger.error("MID rejected our input with message: " + errorMessage);
            throw new MidMissingOrInvalidParameterException(errorMessage);
        }
        catch (NotAuthorizedException e) {
            logger.error("Request is unauthorized for URI " + uri + ": " + e.getMessage());
            throw new MidUnauthorizedException("Request is unauthorized for URI " + uri + ": " + e.getMessage());
        }
        catch (ServiceUnavailableException e) {
            logger.error("MID server returned 503 - service unavailable", (Throwable)e);
            throw new MidServiceUnavailableException("MID service is currently unavailable. Please try again later.");
        }
    }

    private String readErrorMessageFromBody(BadRequestException e) {
        try {
            return ((JsonNode)e.getResponse().readEntity(JsonNode.class)).get("error").asText();
        }
        catch (Exception ex) {
            logger.info("Could not read error from body. Most likely it didn't contain any");
            return e.getMessage();
        }
    }

    private Invocation.Builder prepareClient(URI uri) {
        Client client;
        if (this.configuredClient == null) {
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            if (null != this.clientConfig) {
                clientBuilder.withConfig(this.clientConfig);
            }
            if (null != this.trustSslContext) {
                clientBuilder.sslContext(this.trustSslContext);
            }
            client = clientBuilder.build();
        } else {
            client = this.configuredClient;
        }
        return ((Client)client.register((Object)new MidLoggingFilter())).target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    public static MidRestConnectorBuilder newBuilder() {
        return new MidRestConnectorBuilder();
    }

    @Override
    public void setSslTrustContext(SSLContext trustSslContext) {
        this.trustSslContext = trustSslContext;
    }
}

