/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid.rest;

import ee.sk.mid.exception.MidDeliveryException;
import ee.sk.mid.exception.MidException;
import ee.sk.mid.exception.MidInternalErrorException;
import ee.sk.mid.exception.MidInvalidUserConfigurationException;
import ee.sk.mid.exception.MidNotMidClientException;
import ee.sk.mid.exception.MidPhoneNotAvailableException;
import ee.sk.mid.exception.MidSessionTimeoutException;
import ee.sk.mid.exception.MidUserCancellationException;
import ee.sk.mid.rest.MidConnector;
import ee.sk.mid.rest.dao.MidSessionStatus;
import ee.sk.mid.rest.dao.request.MidSessionStatusRequest;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidSessionStatusPoller {
    public static final String SIGNATURE_SESSION_PATH = "/signature/session/{sessionId}";
    public static final String AUTHENTICATION_SESSION_PATH = "/authentication/session/{sessionId}";
    public static final int DEFAULT_POLLING_SLEEP_TIMEOUT_SECONDS = 3;
    private static final Logger logger = LoggerFactory.getLogger(MidSessionStatusPoller.class);
    private MidConnector connector;
    private int pollingSleepTimeoutSeconds;
    private int longPollingTimeoutSeconds;

    public MidSessionStatusPoller(SessionStatusPollerBuilder builder) {
        this.connector = builder.connector;
        this.pollingSleepTimeoutSeconds = builder.pollingSleepTimeoutSeconds;
        this.longPollingTimeoutSeconds = builder.longPollingTimeoutSeconds;
        if (this.longPollingTimeoutSeconds == 0 && this.pollingSleepTimeoutSeconds == 0) {
            logger.info("Both longPollingTimeoutSeconds and pollingSleepTimeoutSeconds are set to 0. Setting pollingSleepTimeoutSeconds=2.");
            this.pollingSleepTimeoutSeconds = 3;
        }
    }

    public MidSessionStatus fetchFinalSignatureSessionStatus(String sessionId) {
        return this.fetchFinalSessionStatus(sessionId, SIGNATURE_SESSION_PATH);
    }

    public MidSessionStatus fetchFinalAuthenticationSessionStatus(String sessionId) {
        return this.fetchFinalSessionStatus(sessionId, AUTHENTICATION_SESSION_PATH);
    }

    public MidSessionStatus fetchFinalSessionStatus(String sessionId, String path) {
        logger.debug("Starting to poll session status for session " + sessionId);
        try {
            MidSessionStatus sessionStatus = this.pollForFinalSessionStatus(sessionId, path);
            this.validateResult(sessionStatus);
            return sessionStatus;
        }
        catch (InterruptedException e) {
            logger.error("Failed to poll session status: " + e.getMessage());
            throw new MidInternalErrorException("Failed to poll session status: " + e.getMessage(), e);
        }
    }

    private MidSessionStatus pollForFinalSessionStatus(String sessionId, String path) throws InterruptedException {
        MidSessionStatus sessionStatus = null;
        while (sessionStatus == null || StringUtils.equalsIgnoreCase((CharSequence)"RUNNING", (CharSequence)sessionStatus.getState())) {
            logger.debug("Polling session status");
            MidSessionStatusRequest request = new MidSessionStatusRequest(sessionId, this.longPollingTimeoutSeconds);
            sessionStatus = this.connector.getSessionStatus(request, path);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETE", (CharSequence)sessionStatus.getState())) break;
            logger.debug("Sleeping for " + this.pollingSleepTimeoutSeconds + " seconds");
            TimeUnit.SECONDS.sleep(this.pollingSleepTimeoutSeconds);
        }
        logger.debug("Got session final session status response");
        return sessionStatus;
    }

    private void validateResult(MidSessionStatus sessionStatus) {
        String result = sessionStatus.getResult();
        if (result == null) {
            logger.error("Result is missing in the session status response");
            throw new MidInternalErrorException("Result is missing in the session status response");
        }
        this.validateResult(result);
    }

    private void validateResult(String result) throws MidException {
        switch (result) {
            case "OK": {
                return;
            }
            case "TIMEOUT": 
            case "EXPIRED_TRANSACTION": {
                throw new MidSessionTimeoutException();
            }
            case "NOT_MID_CLIENT": {
                throw new MidNotMidClientException();
            }
            case "USER_CANCELLED": {
                throw new MidUserCancellationException();
            }
            case "SIGNATURE_HASH_MISMATCH": {
                throw new MidInvalidUserConfigurationException();
            }
            case "PHONE_ABSENT": {
                throw new MidPhoneNotAvailableException();
            }
            case "SIM_ERROR": 
            case "DELIVERY_ERROR": {
                logger.error("Error with SIM or communicating with it");
                throw new MidDeliveryException();
            }
        }
        throw new MidInternalErrorException("MID returned error code '" + result + "'");
    }

    public static SessionStatusPollerBuilder newBuilder() {
        return new SessionStatusPollerBuilder();
    }

    public static class SessionStatusPollerBuilder {
        private MidConnector connector;
        private int pollingSleepTimeoutSeconds = 0;
        private int longPollingTimeoutSeconds = 0;

        public SessionStatusPollerBuilder withConnector(MidConnector connector) {
            this.connector = connector;
            return this;
        }

        public SessionStatusPollerBuilder withPollingSleepTimeoutSeconds(int pollingSleepTimeoutSeconds) {
            this.pollingSleepTimeoutSeconds = pollingSleepTimeoutSeconds;
            return this;
        }

        public SessionStatusPollerBuilder withLongPollingTimeoutSeconds(int longPollingTimeoutSeconds) {
            this.longPollingTimeoutSeconds = longPollingTimeoutSeconds;
            return this;
        }

        public MidSessionStatusPoller build() {
            return new MidSessionStatusPoller(this);
        }
    }
}

