/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid.rest.dao.request;

import ee.sk.mid.MidDisplayTextFormat;
import ee.sk.mid.MidHashToSign;
import ee.sk.mid.MidHashType;
import ee.sk.mid.MidLanguage;
import ee.sk.mid.exception.MidMissingOrInvalidParameterException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MidAbstractAuthSignRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MidAbstractAuthSignRequestBuilder.class);
    String relyingPartyName;
    String relyingPartyUUID;
    String phoneNumber;
    String nationalIdentityNumber;
    MidHashToSign hashToSign;
    MidLanguage language;
    String displayText;
    MidDisplayTextFormat displayTextFormat;

    protected MidAbstractAuthSignRequestBuilder withRelyingPartyUUID(String relyingPartyUUID) {
        this.relyingPartyUUID = relyingPartyUUID;
        return this;
    }

    protected MidAbstractAuthSignRequestBuilder withRelyingPartyName(String relyingPartyName) {
        this.relyingPartyName = relyingPartyName;
        return this;
    }

    protected MidAbstractAuthSignRequestBuilder withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    protected MidAbstractAuthSignRequestBuilder withNationalIdentityNumber(String nationalIdentityNumber) {
        this.nationalIdentityNumber = nationalIdentityNumber;
        return this;
    }

    protected MidAbstractAuthSignRequestBuilder withHashToSign(MidHashToSign hashToSign) {
        this.hashToSign = hashToSign;
        return this;
    }

    protected MidAbstractAuthSignRequestBuilder withLanguage(MidLanguage language) {
        this.language = language;
        return this;
    }

    protected MidAbstractAuthSignRequestBuilder withDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    public MidAbstractAuthSignRequestBuilder withDisplayTextFormat(MidDisplayTextFormat displayTextFormat) {
        this.displayTextFormat = displayTextFormat;
        return this;
    }

    protected MidHashType getHashType() {
        return this.hashToSign.getHashType();
    }

    protected String getHashInBase64() {
        return this.hashToSign.getHashInBase64();
    }

    protected void validateParameters() throws MidMissingOrInvalidParameterException {
        if (StringUtils.isBlank((CharSequence)this.phoneNumber) || StringUtils.isBlank((CharSequence)this.nationalIdentityNumber)) {
            logger.error("Phone number and national identity must be set");
            throw new MidMissingOrInvalidParameterException("Phone number and national identity must be set");
        }
    }

    protected void validateExtraParameters() throws MidMissingOrInvalidParameterException {
        if (this.hashToSign == null) {
            throw new MidMissingOrInvalidParameterException("hashToSign must be set");
        }
        if (this.language == null) {
            throw new MidMissingOrInvalidParameterException("MidLanguage for user dialog in mobile phone must be set");
        }
    }
}

