/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.mid.rest.dao.request;

import ee.sk.mid.exception.MidException;
import ee.sk.mid.exception.MidMissingOrInvalidParameterException;
import ee.sk.mid.rest.dao.request.MidCertificateRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidCertificateRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MidCertificateRequestBuilder.class);
    private String relyingPartyName;
    private String relyingPartyUUID;
    private String phoneNumber;
    private String nationalIdentityNumber;

    public MidCertificateRequestBuilder withRelyingPartyUUID(String relyingPartyUUID) {
        this.relyingPartyUUID = relyingPartyUUID;
        return this;
    }

    public MidCertificateRequestBuilder withRelyingPartyName(String relyingPartyName) {
        this.relyingPartyName = relyingPartyName;
        return this;
    }

    public MidCertificateRequestBuilder withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public MidCertificateRequestBuilder withNationalIdentityNumber(String nationalIdentityNumber) {
        this.nationalIdentityNumber = nationalIdentityNumber;
        return this;
    }

    public MidCertificateRequest build() throws MidException {
        this.validateParameters();
        MidCertificateRequest request = new MidCertificateRequest();
        request.setRelyingPartyUUID(this.relyingPartyUUID);
        request.setRelyingPartyName(this.relyingPartyName);
        request.setPhoneNumber(this.phoneNumber);
        request.setNationalIdentityNumber(this.nationalIdentityNumber);
        return request;
    }

    private void validateParameters() {
        if (StringUtils.isBlank((CharSequence)this.phoneNumber) || StringUtils.isBlank((CharSequence)this.nationalIdentityNumber)) {
            logger.error("Phone number and national identity must be set");
            throw new MidMissingOrInvalidParameterException("Phone number and national identity must be set");
        }
    }
}

