/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.DigestCalculator;
import ee.sk.smartid.HashType;
import ee.sk.smartid.SignableHash;
import java.security.SecureRandom;

public class AuthenticationHash
extends SignableHash {
    public static AuthenticationHash generateRandomHash(HashType hashType) {
        AuthenticationHash authenticationHash = new AuthenticationHash();
        byte[] generatedDigest = DigestCalculator.calculateDigest(AuthenticationHash.getRandomBytes(), hashType);
        authenticationHash.setHash(generatedDigest);
        authenticationHash.setHashType(hashType);
        return authenticationHash;
    }

    public static AuthenticationHash generateRandomHash() {
        return AuthenticationHash.generateRandomHash(HashType.SHA512);
    }

    private static byte[] getRandomBytes() {
        byte[] randBytes = new byte[64];
        new SecureRandom().nextBytes(randBytes);
        return randBytes;
    }
}

