/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.AuthenticationHash;
import ee.sk.smartid.CertificateParser;
import ee.sk.smartid.SmartIdAuthenticationResponse;
import ee.sk.smartid.SmartIdRequestBuilder;
import ee.sk.smartid.exception.ClientNotSupportedException;
import ee.sk.smartid.exception.DocumentUnusableException;
import ee.sk.smartid.exception.InvalidParametersException;
import ee.sk.smartid.exception.RequestForbiddenException;
import ee.sk.smartid.exception.ServerMaintenanceException;
import ee.sk.smartid.exception.SessionTimeoutException;
import ee.sk.smartid.exception.TechnicalErrorException;
import ee.sk.smartid.exception.UserAccountNotFoundException;
import ee.sk.smartid.exception.UserRefusedException;
import ee.sk.smartid.rest.SessionStatusPoller;
import ee.sk.smartid.rest.SmartIdConnector;
import ee.sk.smartid.rest.dao.AuthenticationSessionRequest;
import ee.sk.smartid.rest.dao.AuthenticationSessionResponse;
import ee.sk.smartid.rest.dao.Capability;
import ee.sk.smartid.rest.dao.NationalIdentity;
import ee.sk.smartid.rest.dao.RequestProperties;
import ee.sk.smartid.rest.dao.SemanticsIdentifier;
import ee.sk.smartid.rest.dao.SessionCertificate;
import ee.sk.smartid.rest.dao.SessionResult;
import ee.sk.smartid.rest.dao.SessionSignature;
import ee.sk.smartid.rest.dao.SessionStatus;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRequestBuilder
extends SmartIdRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationRequestBuilder.class);

    public AuthenticationRequestBuilder(SmartIdConnector connector, SessionStatusPoller sessionStatusPoller) {
        super(connector, sessionStatusPoller);
        logger.debug("Instantiating authentication request builder");
    }

    @Override
    public AuthenticationRequestBuilder withRelyingPartyUUID(String relyingPartyUUID) {
        super.withRelyingPartyUUID(relyingPartyUUID);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withRelyingPartyName(String relyingPartyName) {
        super.withRelyingPartyName(relyingPartyName);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withDocumentNumber(String documentNumber) {
        super.withDocumentNumber(documentNumber);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withNationalIdentity(NationalIdentity nationalIdentity) {
        super.withNationalIdentity(nationalIdentity);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withNationalIdentityNumber(String nationalIdentityNumber) {
        super.withNationalIdentityNumber(nationalIdentityNumber);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withSemanticsIdentifierAsString(String semanticsIdentifier) {
        super.withSemanticsIdentifierAsString(semanticsIdentifier);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withSemanticsIdentifier(SemanticsIdentifier semanticsIdentifier) {
        super.withSemanticsIdentifier(semanticsIdentifier);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withCountryCode(String countryCode) {
        super.withCountryCode(countryCode);
        return this;
    }

    public AuthenticationRequestBuilder withAuthenticationHash(AuthenticationHash authenticationHash) {
        super.withSignableHash(authenticationHash);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withCertificateLevel(String certificateLevel) {
        super.withCertificateLevel(certificateLevel);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withDisplayText(String displayText) {
        super.withDisplayText(displayText);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withNonce(String nonce) {
        super.withNonce(nonce);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withCapabilities(Capability ... capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public AuthenticationRequestBuilder withCapabilities(String ... capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    protected AuthenticationRequestBuilder withRequestProperties(RequestProperties requestProperties) {
        super.withRequestProperties(requestProperties);
        return this;
    }

    public SmartIdAuthenticationResponse authenticate() throws InvalidParametersException, UserAccountNotFoundException, RequestForbiddenException, UserRefusedException, SessionTimeoutException, DocumentUnusableException, TechnicalErrorException, ClientNotSupportedException, ServerMaintenanceException {
        String sessionId = this.initiateAuthentication();
        SessionStatus sessionStatus = this.getSessionStatusPoller().fetchFinalSessionStatus(sessionId);
        SmartIdAuthenticationResponse authenticationResponse = this.createSmartIdAuthenticationResponse(sessionStatus);
        return authenticationResponse;
    }

    public String initiateAuthentication() throws InvalidParametersException, UserAccountNotFoundException, RequestForbiddenException, ClientNotSupportedException, ServerMaintenanceException {
        this.validateParameters();
        AuthenticationSessionRequest request = this.createAuthenticationSessionRequest();
        AuthenticationSessionResponse response = this.getAuthenticationResponse(request);
        return response.getSessionID();
    }

    public SmartIdAuthenticationResponse createSmartIdAuthenticationResponse(SessionStatus sessionStatus) throws UserRefusedException, SessionTimeoutException, DocumentUnusableException, TechnicalErrorException {
        this.validateAuthenticationResponse(sessionStatus);
        SessionResult sessionResult = sessionStatus.getResult();
        SessionSignature sessionSignature = sessionStatus.getSignature();
        SessionCertificate certificate = sessionStatus.getCert();
        SmartIdAuthenticationResponse authenticationResponse = new SmartIdAuthenticationResponse();
        authenticationResponse.setEndResult(sessionResult.getEndResult());
        authenticationResponse.setSignedHashInBase64(this.getHashInBase64());
        authenticationResponse.setHashType(this.getHashType());
        authenticationResponse.setSignatureValueInBase64(sessionSignature.getValue());
        authenticationResponse.setAlgorithmName(sessionSignature.getAlgorithm());
        authenticationResponse.setCertificate(CertificateParser.parseX509Certificate(certificate.getValue()));
        authenticationResponse.setRequestedCertificateLevel(this.getCertificateLevel());
        authenticationResponse.setCertificateLevel(certificate.getCertificateLevel());
        authenticationResponse.setDocumentNumber(sessionResult.getDocumentNumber());
        return authenticationResponse;
    }

    @Override
    protected void validateParameters() {
        super.validateParameters();
        if (StringUtils.isBlank((CharSequence)this.getDocumentNumber()) && !this.hasNationalIdentity() && !this.hasSemanticsIdentifier()) {
            logger.error("Either document number, national identity or semantics identifier must be set");
            throw new InvalidParametersException("Either document number, national identity or semantics identifier must be set");
        }
        if (!this.isHashSet() && !this.isSignableDataSet()) {
            logger.error("Signable data or hash with hash type must be set");
            throw new InvalidParametersException("Signable data or hash with hash type must be set");
        }
    }

    private void validateAuthenticationResponse(SessionStatus sessionStatus) {
        this.validateSessionResult(sessionStatus.getResult());
        if (sessionStatus.getSignature() == null) {
            logger.error("Signature was not present in the response");
            throw new TechnicalErrorException("Signature was not present in the response");
        }
        if (sessionStatus.getCert() == null) {
            logger.error("Certificate was not present in the response");
            throw new TechnicalErrorException("Certificate was not present in the response");
        }
    }

    private AuthenticationSessionResponse getAuthenticationResponse(AuthenticationSessionRequest request) {
        NationalIdentity identity = this.getNationalIdentity();
        SemanticsIdentifier semanticsIdentifier = this.getSemanticsIdentifier();
        if (StringUtils.isNotEmpty((CharSequence)this.getDocumentNumber())) {
            return this.getConnector().authenticate(this.getDocumentNumber(), request);
        }
        if (identity != null) {
            return this.getConnector().authenticate(identity, request);
        }
        return this.getConnector().authenticate(semanticsIdentifier, request);
    }

    private AuthenticationSessionRequest createAuthenticationSessionRequest() {
        AuthenticationSessionRequest request = new AuthenticationSessionRequest();
        request.setRelyingPartyUUID(this.getRelyingPartyUUID());
        request.setRelyingPartyName(this.getRelyingPartyName());
        request.setCertificateLevel(this.getCertificateLevel());
        request.setHashType(this.getHashTypeString());
        request.setHash(this.getHashInBase64());
        request.setDisplayText(this.getDisplayText());
        request.setNonce(this.getNonce());
        request.setCapabilities(this.getCapabilities());
        request.setRequestProperties(this.getRequestProperties());
        return request;
    }
}

