/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.exception.TechnicalErrorException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateParser {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static final Logger logger = LoggerFactory.getLogger(CertificateParser.class);

    public static X509Certificate parseX509Certificate(String certificateValue) {
        logger.debug("Parsing X509 certificate");
        String certificateString = "-----BEGIN CERTIFICATE-----\n" + certificateValue + "\n" + END_CERT;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificateString.getBytes(StandardCharsets.UTF_8)));
        }
        catch (CertificateException e) {
            logger.error("Failed to parse X509 certificate from " + certificateString + ". Error " + e.getMessage());
            throw new TechnicalErrorException("Failed to parse X509 certificate from " + certificateString + ". Error " + e.getMessage(), e);
        }
    }
}

