/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.CertificateParser;
import ee.sk.smartid.SmartIdCertificate;
import ee.sk.smartid.SmartIdRequestBuilder;
import ee.sk.smartid.exception.CertificateNotFoundException;
import ee.sk.smartid.exception.ClientNotSupportedException;
import ee.sk.smartid.exception.DocumentUnusableException;
import ee.sk.smartid.exception.InvalidParametersException;
import ee.sk.smartid.exception.RequestForbiddenException;
import ee.sk.smartid.exception.ServerMaintenanceException;
import ee.sk.smartid.exception.SessionTimeoutException;
import ee.sk.smartid.exception.TechnicalErrorException;
import ee.sk.smartid.exception.UserAccountNotFoundException;
import ee.sk.smartid.exception.UserRefusedException;
import ee.sk.smartid.rest.SessionStatusPoller;
import ee.sk.smartid.rest.SmartIdConnector;
import ee.sk.smartid.rest.dao.Capability;
import ee.sk.smartid.rest.dao.CertificateChoiceResponse;
import ee.sk.smartid.rest.dao.CertificateRequest;
import ee.sk.smartid.rest.dao.NationalIdentity;
import ee.sk.smartid.rest.dao.SemanticsIdentifier;
import ee.sk.smartid.rest.dao.SessionCertificate;
import ee.sk.smartid.rest.dao.SessionResult;
import ee.sk.smartid.rest.dao.SessionStatus;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateRequestBuilder
extends SmartIdRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CertificateRequestBuilder.class);

    public CertificateRequestBuilder(SmartIdConnector connector, SessionStatusPoller sessionStatusPoller) {
        super(connector, sessionStatusPoller);
        logger.debug("Instantiating certificate request builder");
    }

    @Override
    public CertificateRequestBuilder withRelyingPartyUUID(String relyingPartyUUID) {
        super.withRelyingPartyUUID(relyingPartyUUID);
        return this;
    }

    @Override
    public CertificateRequestBuilder withRelyingPartyName(String relyingPartyName) {
        super.withRelyingPartyName(relyingPartyName);
        return this;
    }

    @Override
    public CertificateRequestBuilder withDocumentNumber(String documentNumber) {
        super.withDocumentNumber(documentNumber);
        return this;
    }

    @Override
    public CertificateRequestBuilder withNationalIdentity(NationalIdentity nationalIdentity) {
        super.withNationalIdentity(nationalIdentity);
        return this;
    }

    @Override
    public CertificateRequestBuilder withCountryCode(String countryCode) {
        super.withCountryCode(countryCode);
        return this;
    }

    @Override
    public CertificateRequestBuilder withNationalIdentityNumber(String nationalIdentityNumber) {
        super.withNationalIdentityNumber(nationalIdentityNumber);
        return this;
    }

    @Override
    public CertificateRequestBuilder withCertificateLevel(String certificateLevel) {
        super.withCertificateLevel(certificateLevel);
        return this;
    }

    @Override
    public CertificateRequestBuilder withNonce(String nonce) {
        super.withNonce(nonce);
        return this;
    }

    @Override
    public CertificateRequestBuilder withCapabilities(Capability ... capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public CertificateRequestBuilder withCapabilities(String ... capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public CertificateRequestBuilder withSemanticsIdentifierAsString(String semanticsIdentifier) {
        super.withSemanticsIdentifierAsString(semanticsIdentifier);
        return this;
    }

    @Override
    public CertificateRequestBuilder withSemanticsIdentifier(SemanticsIdentifier semanticsIdentifier) {
        super.withSemanticsIdentifier(semanticsIdentifier);
        return this;
    }

    public SmartIdCertificate fetch() throws InvalidParametersException, CertificateNotFoundException, RequestForbiddenException, UserRefusedException, SessionTimeoutException, DocumentUnusableException, TechnicalErrorException, ClientNotSupportedException, ServerMaintenanceException {
        logger.debug("Starting to fetch certificate");
        this.validateParameters();
        String sessionId = this.initiateCertificateChoice();
        SessionStatus sessionStatus = this.getSessionStatusPoller().fetchFinalSessionStatus(sessionId);
        SmartIdCertificate smartIdCertificate = this.createSmartIdCertificate(sessionStatus);
        return smartIdCertificate;
    }

    public String initiateCertificateChoice() throws InvalidParametersException, UserAccountNotFoundException, RequestForbiddenException, ClientNotSupportedException, ServerMaintenanceException {
        this.validateParameters();
        CertificateRequest request = this.createCertificateRequest();
        CertificateChoiceResponse response = this.fetchCertificateChoiceSessionResponse(request);
        return response.getSessionID();
    }

    public SmartIdCertificate createSmartIdCertificate(SessionStatus sessionStatus) {
        this.validateCertificateResponse(sessionStatus);
        SessionCertificate certificate = sessionStatus.getCert();
        SmartIdCertificate smartIdCertificate = new SmartIdCertificate();
        smartIdCertificate.setCertificate(CertificateParser.parseX509Certificate(certificate.getValue()));
        smartIdCertificate.setCertificateLevel(certificate.getCertificateLevel());
        smartIdCertificate.setDocumentNumber(this.getDocumentNumber(sessionStatus));
        return smartIdCertificate;
    }

    private CertificateChoiceResponse fetchCertificateChoiceSessionResponse(CertificateRequest request) {
        if (StringUtils.isNotEmpty((CharSequence)this.getDocumentNumber())) {
            return this.getConnector().getCertificate(this.getDocumentNumber(), request);
        }
        if (this.getSemanticsIdentifier() != null) {
            return this.getConnector().getCertificate(this.getSemanticsIdentifier(), request);
        }
        NationalIdentity identity = this.getNationalIdentity();
        return this.getConnector().getCertificate(identity, request);
    }

    private CertificateRequest createCertificateRequest() {
        CertificateRequest request = new CertificateRequest();
        request.setRelyingPartyUUID(this.getRelyingPartyUUID());
        request.setRelyingPartyName(this.getRelyingPartyName());
        request.setCertificateLevel(this.getCertificateLevel());
        request.setNonce(this.getNonce());
        request.setCapabilities(this.getCapabilities());
        return request;
    }

    public void validateCertificateResponse(SessionStatus sessionStatus) {
        this.validateSessionResult(sessionStatus.getResult());
        SessionCertificate certificate = sessionStatus.getCert();
        if (certificate == null || StringUtils.isBlank((CharSequence)certificate.getValue())) {
            logger.error("Certificate was not present in the session status response");
            throw new TechnicalErrorException("Certificate was not present in the session status response");
        }
        if (StringUtils.isBlank((CharSequence)sessionStatus.getResult().getDocumentNumber())) {
            logger.error("Document number was not present in the session status response");
            throw new TechnicalErrorException("Document number was not present in the session status response");
        }
    }

    @Override
    protected void validateParameters() {
        super.validateParameters();
        if (StringUtils.isBlank((CharSequence)this.getDocumentNumber()) && !this.hasNationalIdentity() && !this.hasSemanticsIdentifier()) {
            logger.error("Either document number, national identity or semantics identifier must be set");
            throw new InvalidParametersException("Either document number, national identity or semantics identifier must be set");
        }
    }

    private String getDocumentNumber(SessionStatus sessionStatus) {
        SessionResult sessionResult = sessionStatus.getResult();
        return sessionResult.getDocumentNumber();
    }
}

