/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

public enum HashType {
    SHA256("SHA-256", "SHA256", new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32}),
    SHA384("SHA-384", "SHA384", new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48}),
    SHA512("SHA-512", "SHA512", new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64});

    private String algorithmName;
    private String hashTypeName;
    private byte[] digestInfoPrefix;

    private HashType(String algorithmName, String hashTypeName, byte[] digestInfoPrefix) {
        this.algorithmName = algorithmName;
        this.hashTypeName = hashTypeName;
        this.digestInfoPrefix = (byte[])digestInfoPrefix.clone();
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getHashTypeName() {
        return this.hashTypeName;
    }

    public byte[] getDigestInfoPrefix() {
        return (byte[])this.digestInfoPrefix.clone();
    }
}

