/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.DigestCalculator;
import ee.sk.smartid.HashType;
import ee.sk.smartid.VerificationCodeCalculator;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;

public class SignableData
implements Serializable {
    private byte[] dataToSign;
    private HashType hashType = HashType.SHA512;

    public SignableData(byte[] dataToSign) {
        this.dataToSign = (byte[])dataToSign.clone();
    }

    public String calculateHashInBase64() {
        byte[] digest = this.calculateHash();
        return Base64.encodeBase64String((byte[])digest);
    }

    public byte[] calculateHash() {
        return DigestCalculator.calculateDigest(this.dataToSign, this.hashType);
    }

    public String calculateVerificationCode() {
        byte[] digest = this.calculateHash();
        return VerificationCodeCalculator.calculate(digest);
    }

    public void setHashType(HashType hashType) {
        this.hashType = hashType;
    }

    public HashType getHashType() {
        return this.hashType;
    }
}

