/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.SignableData;
import ee.sk.smartid.SignableHash;
import ee.sk.smartid.SmartIdRequestBuilder;
import ee.sk.smartid.SmartIdSignature;
import ee.sk.smartid.exception.ClientNotSupportedException;
import ee.sk.smartid.exception.DocumentUnusableException;
import ee.sk.smartid.exception.InvalidParametersException;
import ee.sk.smartid.exception.RequestForbiddenException;
import ee.sk.smartid.exception.ServerMaintenanceException;
import ee.sk.smartid.exception.SessionTimeoutException;
import ee.sk.smartid.exception.TechnicalErrorException;
import ee.sk.smartid.exception.UserAccountNotFoundException;
import ee.sk.smartid.exception.UserRefusedException;
import ee.sk.smartid.rest.SessionStatusPoller;
import ee.sk.smartid.rest.SmartIdConnector;
import ee.sk.smartid.rest.dao.Capability;
import ee.sk.smartid.rest.dao.RequestProperties;
import ee.sk.smartid.rest.dao.SemanticsIdentifier;
import ee.sk.smartid.rest.dao.SessionSignature;
import ee.sk.smartid.rest.dao.SessionStatus;
import ee.sk.smartid.rest.dao.SignatureSessionRequest;
import ee.sk.smartid.rest.dao.SignatureSessionResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureRequestBuilder
extends SmartIdRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SignatureRequestBuilder.class);

    public SignatureRequestBuilder(SmartIdConnector connector, SessionStatusPoller sessionStatusPoller) {
        super(connector, sessionStatusPoller);
        logger.debug("Instantiating signature request builder");
    }

    @Override
    public SignatureRequestBuilder withRelyingPartyUUID(String relyingPartyUUID) {
        super.withRelyingPartyUUID(relyingPartyUUID);
        return this;
    }

    @Override
    public SignatureRequestBuilder withRelyingPartyName(String relyingPartyName) {
        super.withRelyingPartyName(relyingPartyName);
        return this;
    }

    @Override
    public SignatureRequestBuilder withDocumentNumber(String documentNumber) {
        super.withDocumentNumber(documentNumber);
        return this;
    }

    @Override
    public SignatureRequestBuilder withSemanticsIdentifierAsString(String semanticsIdentifier) {
        super.withSemanticsIdentifierAsString(semanticsIdentifier);
        return this;
    }

    @Override
    public SignatureRequestBuilder withSemanticsIdentifier(SemanticsIdentifier semanticsIdentifier) {
        super.withSemanticsIdentifier(semanticsIdentifier);
        return this;
    }

    @Override
    public SignatureRequestBuilder withSignableData(SignableData dataToSign) {
        super.withSignableData(dataToSign);
        return this;
    }

    @Override
    public SignatureRequestBuilder withSignableHash(SignableHash hashToSign) {
        super.withSignableHash(hashToSign);
        return this;
    }

    @Override
    public SignatureRequestBuilder withCertificateLevel(String certificateLevel) {
        super.withCertificateLevel(certificateLevel);
        return this;
    }

    @Override
    public SignatureRequestBuilder withDisplayText(String displayText) {
        super.withDisplayText(displayText);
        return this;
    }

    @Override
    public SignatureRequestBuilder withNonce(String nonce) {
        super.withNonce(nonce);
        return this;
    }

    @Override
    public SignatureRequestBuilder withCapabilities(Capability ... capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public SignatureRequestBuilder withCapabilities(String ... capabilities) {
        super.withCapabilities(capabilities);
        return this;
    }

    @Override
    public SignatureRequestBuilder withRequestProperties(RequestProperties requestProperties) {
        super.withRequestProperties(requestProperties);
        return this;
    }

    public SmartIdSignature sign() throws InvalidParametersException, UserAccountNotFoundException, RequestForbiddenException, UserRefusedException, SessionTimeoutException, DocumentUnusableException, TechnicalErrorException, ClientNotSupportedException, ServerMaintenanceException {
        this.validateParameters();
        String sessionId = this.initiateSigning();
        SessionStatus sessionStatus = this.getSessionStatusPoller().fetchFinalSessionStatus(sessionId);
        SmartIdSignature signature = this.createSmartIdSignature(sessionStatus);
        return signature;
    }

    public String initiateSigning() throws InvalidParametersException, UserAccountNotFoundException, RequestForbiddenException, ClientNotSupportedException, ServerMaintenanceException {
        this.validateParameters();
        SignatureSessionRequest request = this.createSignatureSessionRequest();
        SignatureSessionResponse response = this.getSignatureResponse(request);
        return response.getSessionID();
    }

    private SignatureSessionResponse getSignatureResponse(SignatureSessionRequest request) {
        if (StringUtils.isNotEmpty((CharSequence)this.getDocumentNumber())) {
            return this.getConnector().sign(this.getDocumentNumber(), request);
        }
        return this.getConnector().sign(this.getSemanticsIdentifier(), request);
    }

    public SmartIdSignature createSmartIdSignature(SessionStatus sessionStatus) {
        this.validateSignatureResponse(sessionStatus);
        SessionSignature sessionSignature = sessionStatus.getSignature();
        SmartIdSignature signature = new SmartIdSignature();
        signature.setValueInBase64(sessionSignature.getValue());
        signature.setAlgorithmName(sessionSignature.getAlgorithm());
        signature.setDocumentNumber(sessionStatus.getResult().getDocumentNumber());
        return signature;
    }

    @Override
    protected void validateParameters() {
        super.validateParameters();
        if (StringUtils.isBlank((CharSequence)this.getDocumentNumber()) && !this.hasSemanticsIdentifier()) {
            logger.error("Document number or semantics identifier must be set");
            throw new InvalidParametersException("Document number or semantics identifier must be set");
        }
        if (!this.isHashSet() && !this.isSignableDataSet()) {
            logger.error("Signable data or hash with hash type must be set");
            throw new InvalidParametersException("Signable data or hash with hash type must be set");
        }
    }

    private void validateSignatureResponse(SessionStatus sessionStatus) {
        this.validateSessionResult(sessionStatus.getResult());
        if (sessionStatus.getSignature() == null) {
            logger.error("Signature was not present in the response");
            throw new TechnicalErrorException("Signature was not present in the response");
        }
    }

    private SignatureSessionRequest createSignatureSessionRequest() {
        SignatureSessionRequest request = new SignatureSessionRequest();
        request.setRelyingPartyUUID(this.getRelyingPartyUUID());
        request.setRelyingPartyName(this.getRelyingPartyName());
        request.setCertificateLevel(this.getCertificateLevel());
        request.setHashType(this.getHashTypeString());
        request.setHash(this.getHashInBase64());
        request.setDisplayText(this.getDisplayText());
        request.setNonce(this.getNonce());
        request.setCapabilities(this.getCapabilities());
        request.setRequestProperties(this.getRequestProperties());
        return request;
    }
}

