/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid;

import ee.sk.smartid.HashType;
import ee.sk.smartid.SignableData;
import ee.sk.smartid.SignableHash;
import ee.sk.smartid.exception.DocumentUnusableException;
import ee.sk.smartid.exception.InvalidParametersException;
import ee.sk.smartid.exception.SessionTimeoutException;
import ee.sk.smartid.exception.TechnicalErrorException;
import ee.sk.smartid.exception.UserRefusedException;
import ee.sk.smartid.rest.SessionStatusPoller;
import ee.sk.smartid.rest.SmartIdConnector;
import ee.sk.smartid.rest.dao.Capability;
import ee.sk.smartid.rest.dao.NationalIdentity;
import ee.sk.smartid.rest.dao.RequestProperties;
import ee.sk.smartid.rest.dao.SemanticsIdentifier;
import ee.sk.smartid.rest.dao.SessionResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartIdRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SmartIdRequestBuilder.class);
    private SmartIdConnector connector;
    private SessionStatusPoller sessionStatusPoller;
    private String relyingPartyUUID;
    private String relyingPartyName;
    private String countryCode;
    private String nationalIdentityNumber;
    private NationalIdentity nationalIdentity;
    private SemanticsIdentifier semanticsIdentifier;
    private String documentNumber;
    private String certificateLevel;
    private SignableData dataToSign;
    private SignableHash hashToSign;
    private String nonce;
    private String displayText;
    private Set<String> capabilities;
    private RequestProperties requestProperties;

    protected SmartIdRequestBuilder(SmartIdConnector connector, SessionStatusPoller sessionStatusPoller) {
        this.connector = connector;
        this.sessionStatusPoller = sessionStatusPoller;
    }

    protected SmartIdRequestBuilder withRelyingPartyUUID(String relyingPartyUUID) {
        this.relyingPartyUUID = relyingPartyUUID;
        return this;
    }

    protected SmartIdRequestBuilder withRelyingPartyName(String relyingPartyName) {
        this.relyingPartyName = relyingPartyName;
        return this;
    }

    protected SmartIdRequestBuilder withDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    protected SmartIdRequestBuilder withNationalIdentity(NationalIdentity nationalIdentity) {
        this.nationalIdentity = nationalIdentity;
        return this;
    }

    protected SmartIdRequestBuilder withNationalIdentityNumber(String nationalIdentityNumber) {
        this.nationalIdentityNumber = nationalIdentityNumber;
        return this;
    }

    public SmartIdRequestBuilder withSemanticsIdentifierAsString(String semanticsIdentifier) {
        this.semanticsIdentifier = new SemanticsIdentifier(semanticsIdentifier);
        return this;
    }

    public SmartIdRequestBuilder withSemanticsIdentifier(SemanticsIdentifier semanticsIdentifier) {
        this.semanticsIdentifier = semanticsIdentifier;
        return this;
    }

    protected SmartIdRequestBuilder withCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    protected SmartIdRequestBuilder withSignableData(SignableData dataToSign) {
        this.dataToSign = dataToSign;
        return this;
    }

    protected SmartIdRequestBuilder withSignableHash(SignableHash hashToSign) {
        this.hashToSign = hashToSign;
        return this;
    }

    protected SmartIdRequestBuilder withCertificateLevel(String certificateLevel) {
        this.certificateLevel = certificateLevel;
        return this;
    }

    protected SmartIdRequestBuilder withCapabilities(Capability ... capabilities) {
        HashSet<String> capabilitySet = new HashSet<String>();
        for (Capability capability : capabilities) {
            capabilitySet.add(capability.toString());
        }
        this.capabilities = capabilitySet;
        return this;
    }

    protected SmartIdRequestBuilder withCapabilities(String ... capabilities) {
        this.capabilities = new HashSet<String>(Arrays.asList(capabilities));
        return this;
    }

    protected SmartIdRequestBuilder withNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    protected SmartIdRequestBuilder withDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    protected SmartIdRequestBuilder withRequestProperties(RequestProperties requestProperties) {
        this.requestProperties = requestProperties;
        return this;
    }

    protected void validateParameters() {
        if (StringUtils.isBlank((CharSequence)this.relyingPartyUUID)) {
            logger.error("Relying Party UUID parameter must be set");
            throw new InvalidParametersException("Relying Party UUID parameter must be set");
        }
        if (StringUtils.isBlank((CharSequence)this.relyingPartyName)) {
            logger.error("Relying Party Name parameter must be set");
            throw new InvalidParametersException("Relying Party Name parameter must be set");
        }
    }

    protected void validateSessionResult(SessionResult result) {
        if (result == null) {
            logger.error("Result is missing in the session status response");
            throw new TechnicalErrorException("Result is missing in the session status response");
        }
        String endResult = result.getEndResult();
        if (StringUtils.equalsIgnoreCase((CharSequence)endResult, (CharSequence)"USER_REFUSED")) {
            logger.debug("User has refused");
            throw new UserRefusedException();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)endResult, (CharSequence)"TIMEOUT")) {
            logger.debug("Session timeout");
            throw new SessionTimeoutException();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)endResult, (CharSequence)"DOCUMENT_UNUSABLE")) {
            logger.debug("Document unusable");
            throw new DocumentUnusableException();
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)endResult, (CharSequence)"OK")) {
            logger.warn("Session status end result is '" + endResult + "'");
            throw new TechnicalErrorException("Session status end result is '" + endResult + "'");
        }
    }

    protected boolean hasNationalIdentity() {
        return this.nationalIdentity != null || StringUtils.isNotBlank((CharSequence)this.countryCode) && StringUtils.isNotBlank((CharSequence)this.nationalIdentityNumber);
    }

    protected boolean hasSemanticsIdentifier() {
        return this.semanticsIdentifier != null;
    }

    protected NationalIdentity getNationalIdentity() {
        if (this.nationalIdentity != null) {
            return this.nationalIdentity;
        }
        if (this.countryCode == null || this.nationalIdentityNumber == null) {
            return null;
        }
        return new NationalIdentity(this.countryCode, this.nationalIdentityNumber);
    }

    protected boolean isHashSet() {
        return this.hashToSign != null && this.hashToSign.areFieldsFilled();
    }

    protected boolean isSignableDataSet() {
        return this.dataToSign != null;
    }

    protected String getHashTypeString() {
        return this.getHashType().getHashTypeName();
    }

    protected HashType getHashType() {
        if (this.hashToSign != null) {
            return this.hashToSign.getHashType();
        }
        return this.dataToSign.getHashType();
    }

    protected String getHashInBase64() {
        if (this.hashToSign != null) {
            return this.hashToSign.getHashInBase64();
        }
        return this.dataToSign.calculateHashInBase64();
    }

    public SmartIdConnector getConnector() {
        return this.connector;
    }

    protected SessionStatusPoller getSessionStatusPoller() {
        return this.sessionStatusPoller;
    }

    protected String getRelyingPartyUUID() {
        return this.relyingPartyUUID;
    }

    protected String getRelyingPartyName() {
        return this.relyingPartyName;
    }

    protected String getDocumentNumber() {
        return this.documentNumber;
    }

    protected String getCertificateLevel() {
        return this.certificateLevel;
    }

    protected String getNonce() {
        return this.nonce;
    }

    protected String getDisplayText() {
        return this.displayText;
    }

    public SemanticsIdentifier getSemanticsIdentifier() {
        return this.semanticsIdentifier;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public RequestProperties getRequestProperties() {
        return this.requestProperties;
    }
}

