/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.smartid.rest;

import ee.sk.smartid.exception.CertificateNotFoundException;
import ee.sk.smartid.exception.ClientNotSupportedException;
import ee.sk.smartid.exception.InvalidParametersException;
import ee.sk.smartid.exception.RequestForbiddenException;
import ee.sk.smartid.exception.ServerMaintenanceException;
import ee.sk.smartid.exception.SessionNotFoundException;
import ee.sk.smartid.exception.UnauthorizedException;
import ee.sk.smartid.exception.UserAccountNotFoundException;
import ee.sk.smartid.rest.LoggingFilter;
import ee.sk.smartid.rest.SmartIdConnector;
import ee.sk.smartid.rest.dao.AuthenticationSessionRequest;
import ee.sk.smartid.rest.dao.AuthenticationSessionResponse;
import ee.sk.smartid.rest.dao.CertificateChoiceResponse;
import ee.sk.smartid.rest.dao.CertificateRequest;
import ee.sk.smartid.rest.dao.NationalIdentity;
import ee.sk.smartid.rest.dao.SemanticsIdentifier;
import ee.sk.smartid.rest.dao.SessionStatus;
import ee.sk.smartid.rest.dao.SessionStatusRequest;
import ee.sk.smartid.rest.dao.SignatureSessionRequest;
import ee.sk.smartid.rest.dao.SignatureSessionResponse;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartIdRestConnector
implements SmartIdConnector {
    private static final Logger logger = LoggerFactory.getLogger(SmartIdRestConnector.class);
    private static final String SESSION_STATUS_URI = "/session/{sessionId}";
    private static final String CERTIFICATE_CHOICE_BY_NATIONAL_IDENTITY_PATH = "/certificatechoice/pno/{country}/{nationalIdentityNumber}";
    private static final String CERTIFICATE_CHOICE_BY_DOCUMENT_NUMBER_PATH = "/certificatechoice/document/{documentNumber}";
    private static final String CERTIFICATE_CHOICE_BY_NATURAL_PERSON_SEMANTICS_IDENTIFIER = "/certificatechoice/etsi/{semanticsIdentifier}";
    private static final String SIGNATURE_BY_DOCUMENT_NUMBER_PATH = "/signature/document/{documentNumber}";
    private static final String SIGNATURE_BY_NATURAL_PERSON_SEMANTICS_IDENTIFIER = "/signature/etsi/{semanticsIdentifier}";
    private static final String AUTHENTICATE_BY_DOCUMENT_NUMBER_PATH = "/authentication/document/{documentNumber}";
    private static final String AUTHENTICATE_BY_NATIONAL_IDENTITY_PATH = "/authentication/pno/{country}/{nationalIdentityNumber}";
    private static final String AUTHENTICATE_BY_NATURAL_PERSON_SEMANTICS_IDENTIFIER = "/authentication/etsi/{semanticsIdentifier}";
    private String endpointUrl;
    private transient Configuration clientConfig;
    private transient Client configuredClient;
    private TimeUnit sessionStatusResponseSocketOpenTimeUnit;
    private long sessionStatusResponseSocketOpenTimeValue;
    private static final long serialVersionUID = 42L;
    private transient SSLContext sslContext;

    public SmartIdRestConnector(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public SmartIdRestConnector(String endpointUrl, Configuration clientConfig) {
        this(endpointUrl);
        this.clientConfig = clientConfig;
    }

    public SmartIdRestConnector(String endpointUrl, Client configuredClient) {
        this(endpointUrl);
        this.configuredClient = configuredClient;
    }

    @Override
    public SessionStatus getSessionStatus(String sessionId) throws SessionNotFoundException {
        logger.debug("Getting session status for " + sessionId);
        SessionStatusRequest request = this.createSessionStatusRequest(sessionId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.endpointUrl).path(SESSION_STATUS_URI);
        this.addResponseSocketOpenTimeUrlParameter(request, uriBuilder);
        URI uri = uriBuilder.build(new Object[]{request.getSessionId()});
        try {
            return (SessionStatus)this.prepareClient(uri).get(SessionStatus.class);
        }
        catch (NotFoundException e) {
            logger.warn("Session " + request + " not found: " + e.getMessage());
            throw new SessionNotFoundException();
        }
    }

    @Override
    public CertificateChoiceResponse getCertificate(NationalIdentity identity, CertificateRequest request) {
        logger.debug("Getting certificate for " + identity);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(CERTIFICATE_CHOICE_BY_NATIONAL_IDENTITY_PATH).build(new Object[]{identity.getCountryCode(), identity.getNationalIdentityNumber()});
        return this.postCertificateRequest(uri, request);
    }

    @Override
    public CertificateChoiceResponse getCertificate(String documentNumber, CertificateRequest request) {
        logger.debug("Getting certificate for document " + documentNumber);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(CERTIFICATE_CHOICE_BY_DOCUMENT_NUMBER_PATH).build(new Object[]{documentNumber});
        return this.postCertificateRequest(uri, request);
    }

    @Override
    public CertificateChoiceResponse getCertificate(SemanticsIdentifier semanticsIdentifier, CertificateRequest request) {
        logger.debug("Getting certificate for identifier " + semanticsIdentifier.getIdentifier());
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(CERTIFICATE_CHOICE_BY_NATURAL_PERSON_SEMANTICS_IDENTIFIER).build(new Object[]{semanticsIdentifier.getIdentifier()});
        return this.postCertificateRequest(uri, request);
    }

    @Override
    public SignatureSessionResponse sign(String documentNumber, SignatureSessionRequest request) {
        logger.debug("Signing for document " + documentNumber);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(SIGNATURE_BY_DOCUMENT_NUMBER_PATH).build(new Object[]{documentNumber});
        try {
            return this.postRequest(uri, request, SignatureSessionResponse.class);
        }
        catch (NotFoundException e) {
            logger.warn("User account not found for signing with document " + documentNumber);
            throw new UserAccountNotFoundException();
        }
        catch (ForbiddenException e) {
            logger.warn("No permission to issue the request");
            throw new RequestForbiddenException();
        }
    }

    @Override
    public SignatureSessionResponse sign(SemanticsIdentifier semanticsIdentifier, SignatureSessionRequest request) {
        logger.debug("Signing for semantics identifier " + semanticsIdentifier);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(SIGNATURE_BY_NATURAL_PERSON_SEMANTICS_IDENTIFIER).build(new Object[]{semanticsIdentifier.getIdentifier()});
        try {
            return this.postRequest(uri, request, SignatureSessionResponse.class);
        }
        catch (NotFoundException e) {
            logger.warn("User account not found for semantics identifier " + semanticsIdentifier.getIdentifier());
            throw new UserAccountNotFoundException();
        }
        catch (ForbiddenException e) {
            logger.warn("No permission to issue the request");
            throw new RequestForbiddenException();
        }
    }

    @Override
    public AuthenticationSessionResponse authenticate(String documentNumber, AuthenticationSessionRequest request) {
        logger.debug("Authenticating for document " + documentNumber);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(AUTHENTICATE_BY_DOCUMENT_NUMBER_PATH).build(new Object[]{documentNumber});
        return this.postAuthenticationRequest(uri, request);
    }

    @Override
    public AuthenticationSessionResponse authenticate(NationalIdentity identity, AuthenticationSessionRequest request) {
        logger.debug("Authenticating for " + identity);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(AUTHENTICATE_BY_NATIONAL_IDENTITY_PATH).build(new Object[]{identity.getCountryCode(), identity.getNationalIdentityNumber()});
        return this.postAuthenticationRequest(uri, request);
    }

    @Override
    public AuthenticationSessionResponse authenticate(SemanticsIdentifier semanticsIdentifier, AuthenticationSessionRequest request) {
        logger.debug("Authenticating for " + semanticsIdentifier);
        URI uri = UriBuilder.fromUri((String)this.endpointUrl).path(AUTHENTICATE_BY_NATURAL_PERSON_SEMANTICS_IDENTIFIER).build(new Object[]{semanticsIdentifier.getIdentifier()});
        return this.postAuthenticationRequest(uri, request);
    }

    @Override
    public void setSessionStatusResponseSocketOpenTime(TimeUnit sessionStatusResponseSocketOpenTimeUnit, long sessionStatusResponseSocketOpenTimeValue) {
        this.sessionStatusResponseSocketOpenTimeUnit = sessionStatusResponseSocketOpenTimeUnit;
        this.sessionStatusResponseSocketOpenTimeValue = sessionStatusResponseSocketOpenTimeValue;
    }

    private Invocation.Builder prepareClient(URI uri) {
        Client client;
        if (this.configuredClient == null) {
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            if (null != this.clientConfig) {
                clientBuilder.withConfig(this.clientConfig);
            }
            if (null != this.sslContext) {
                clientBuilder.sslContext(this.sslContext);
            }
            client = clientBuilder.build();
        } else {
            client = this.configuredClient;
        }
        return ((Client)client.register((Object)new LoggingFilter())).target(uri).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
    }

    private CertificateChoiceResponse postCertificateRequest(URI uri, CertificateRequest request) {
        try {
            return this.postRequest(uri, request, CertificateChoiceResponse.class);
        }
        catch (NotFoundException e) {
            logger.warn("Certificate not found for URI " + uri + ": " + e.getMessage());
            throw new CertificateNotFoundException();
        }
        catch (ForbiddenException e) {
            logger.warn("No permission to issue the request");
            throw new RequestForbiddenException();
        }
    }

    private AuthenticationSessionResponse postAuthenticationRequest(URI uri, AuthenticationSessionRequest request) {
        try {
            return this.postRequest(uri, request, AuthenticationSessionResponse.class);
        }
        catch (NotFoundException e) {
            logger.warn("User account not found for URI " + uri + ": " + e.getMessage());
            throw new UserAccountNotFoundException();
        }
        catch (ForbiddenException e) {
            logger.warn("No permission to issue the request");
            throw new RequestForbiddenException();
        }
    }

    private <T, V> T postRequest(URI uri, V request, Class<T> responseType) {
        try {
            Entity requestEntity = Entity.entity(request, (String)"application/json");
            return (T)this.prepareClient(uri).post(requestEntity, responseType);
        }
        catch (NotAuthorizedException e) {
            logger.warn("Request is unauthorized for URI " + uri + ": " + e.getMessage());
            throw new UnauthorizedException();
        }
        catch (BadRequestException e) {
            logger.warn("Request is invalid for URI " + uri + ": " + e.getMessage());
            throw new InvalidParametersException();
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 480) {
                logger.warn("Client-side API is too old and not supported anymore");
                throw new ClientNotSupportedException();
            }
            throw e;
        }
        catch (ServerErrorException e) {
            if (e.getResponse().getStatus() == 580) {
                logger.warn("Server is under maintenance, retry later");
                throw new ServerMaintenanceException();
            }
            throw e;
        }
    }

    private SessionStatusRequest createSessionStatusRequest(String sessionId) {
        SessionStatusRequest request = new SessionStatusRequest(sessionId);
        if (this.sessionStatusResponseSocketOpenTimeUnit != null && this.sessionStatusResponseSocketOpenTimeValue > 0L) {
            request.setResponseSocketOpenTime(this.sessionStatusResponseSocketOpenTimeUnit, this.sessionStatusResponseSocketOpenTimeValue);
        }
        return request;
    }

    private void addResponseSocketOpenTimeUrlParameter(SessionStatusRequest request, UriBuilder uriBuilder) {
        if (request.isResponseSocketOpenTimeSet()) {
            TimeUnit timeUnit = request.getResponseSocketOpenTimeUnit();
            long timeValue = request.getResponseSocketOpenTimeValue();
            long queryTimeoutInMilliseconds = timeUnit.toMillis(timeValue);
            uriBuilder.queryParam("timeoutMs", new Object[]{queryTimeoutInMilliseconds});
        }
    }

    @Override
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

