/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

/**
 * This class is linked from plugin.xml and handles the registration of the variable
 * classpath entry pointing to the emma plugin root. This variable is used to add
 * a reference to emma.jar when Emma is activated for a project.
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2006-feb-09
 */
public class EmmaHomeInitializer extends ClasspathVariableInitializer{
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jdt.core.ClasspathVariableInitializer#initialize(java.lang.String)
	 */
	public void initialize(String variable){
		if(EmmaPlugin.EMMA_HOME.equals(variable)){
			initializeHome();
		}
	}

	private void initializeHome(){
		final Bundle bundle= Platform.getBundle(EmmaPlugin.ID);
		if(bundle == null){
			JavaCore.removeClasspathVariable(EmmaPlugin.EMMA_HOME, null);
		}else{
			boolean success= true;
			
			final URL installLocation= bundle.getEntry("/");
			URL local= null;
			try{
				local= Platform.asLocalURL(installLocation);
			}catch(IOException e){
				JavaCore.removeClasspathVariable(EmmaPlugin.EMMA_HOME, null);
				success= false;
			}

			if(success){
				try{
					final String fullPath= new File(local.getPath()).getAbsolutePath();
					JavaCore.setClasspathVariable(EmmaPlugin.EMMA_HOME, Path.fromOSString(fullPath), null);
				}catch(JavaModelException e1){
					JavaCore.removeClasspathVariable(EmmaPlugin.EMMA_HOME, null);
				}
			}
		}
	}
}