/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma;

import java.util.Collections;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

import com.vladium.emma.property.Property;

/**
 * Holds the properties the keyes and default values for the properties that can
 * be set from the property page for each project.
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2005-okt-03
 */
public class Properties{
	/** Hidden constructor */
	private Properties(){
		//This object can not be instantiated
	}

	//Key to store coverage report data for a resource
	public static final Property COVERAGE_SUFFIX_CLASS= getProp("covSuffixClass", null);
	public static final Property COVERAGE_SUFFIX_METHOD= getProp("covSuffixMethod", null);
	public static final Property COVERAGE_SUFFIX_BLOCK= getProp("covSuffixBlock", null);
	public static final Property COVERAGE_SUFFIX_LINE= getProp("covSuffixLine", null);

	//The flag that enables emma instrumentation
	public static final Property BUILDER_ENABLED= getProp("builderEnabled", Boolean.FALSE);

	//The thresholds for packages and source files coverage measurement
	public static final Property PACKAGE_CLASS_THRESHOLD= getProp("pClassThreshold", new Integer(100));
	public static final Property PACKAGE_METHOD_THRESHOLD= getProp("pMethodThreshold", new Integer(0));
	public static final Property PACKAGE_BLOCK_THRESHOLD= getProp("pBlockThreshold", new Integer(0));
	public static final Property PACKAGE_LINE_THRESHOLD= getProp("pLineThreshold", new Integer(0));
	public static final Property SOURCE_CLASS_THRESHOLD= getProp("sClassThreshold", new Integer(0));
	public static final Property SOURCE_METHOD_THRESHOLD= getProp("sMethodThreshold", new Integer(0));
	public static final Property SOURCE_BLOCK_THRESHOLD= getProp("sBlockThreshold", new Integer(0));
	public static final Property SOURCE_LINE_THRESHOLD= getProp("sLineThreshold", new Integer(80));

	//Key to store persistent property indicating if a resource is included in instrumentation
	public static final Property IS_INSTRUMENTED= getProp("isInstrumented", null);
	public static final String INSTR_INCLUDE= "in";
	public static final String INSTR_EXCLUDE= "ex";

	//List of filters that includes classes	
	public static final Property INCLUDE_FILTER_LIST= getProp("inFilterList", Collections.EMPTY_SET);

	public static final Property INCLUDE_FILTER_IS_REGEX= getProp("inFilterIsRegEx", Boolean.FALSE);

	//List of filters that excludes classes
	public static final Property EXCLUDE_FILTER_LIST= getProp("exFilterList", Collections.EMPTY_SET);

	public static final Property EXCLUDE_FILTER_IS_REGEX= getProp("exFilterIsRegEx", Boolean.FALSE);

	//The root path to the directory where instrumented jars are put
	public static final Property INSTRUMENTED_ROOT= getProp("instrResultDir", "emma-monitored");

	private static final IPath reportBasePath= new Path("emma-result").addTrailingSeparator();

	//The base path to the html report index file. 
	//A directory of related files is also created
	public static final Property HTMLRESULT_ROOT= getProp("htmlResultFile", reportBasePath.append("html").addTrailingSeparator().append("index.html").toOSString());
	//The path to the xml report file
	public static final Property XMLRESULT_ROOT= getProp("xmlResultFile", reportBasePath.append("result.xml").toOSString());
	//The path to the text report file
	public static final Property TXTRESULT_ROOT= getProp("txtResultFile", reportBasePath.append("result.txt").toOSString());


	//-------------------------Plugin wide preferences -----------------------------
	//Decoration of included source names
	public static final Property DECORATION_INCLUDED= getProp("incDecoration", "+");
	//Decoration of excluded source names	
	public static final Property DECORATION_EXCLUDED= getProp("excDecoration", "-");

	//The flags indicating which decorations that are displayed
	public static final Property PACKAGE_CLASS_FLAG= getProp("pClassFlag", Boolean.TRUE);
	public static final Property PACKAGE_METHOD_FLAG= getProp("pMethodFlag", Boolean.FALSE);
	public static final Property PACKAGE_BLOCK_FLAG= getProp("pBlockFlag", Boolean.FALSE);
	public static final Property PACKAGE_LINE_FLAG= getProp("pLineFlag", Boolean.FALSE);
	public static final Property SOURCE_CLASS_FLAG= getProp("sClassFlag", Boolean.FALSE);
	public static final Property SOURCE_METHOD_FLAG= getProp("sMethodFlag", Boolean.FALSE);
	public static final Property SOURCE_BLOCK_FLAG= getProp("sBlockFlag", Boolean.FALSE);
	public static final Property SOURCE_LINE_FLAG= getProp("sLineFlag", Boolean.TRUE);

	public static final Property NAME_DECORATION_ACTIVE= getProp("nameDecorationActive", Boolean.TRUE);


	//----------------------Internal preferences------------------------------------
	public static final Property EMMA_JAR_PATH= getProp("pluginJarPath", new Path("lib/internal/emma.jar"));

	private static final IPath internalBasePath= new Path(".emma").addTrailingSeparator();

	//The coverage file file that gets output after a jvm execution
	public static final Property INTERNAL_COVERAGE_JVM_ARG= getProp("covJvmArg", "-Demma.coverage.out.file=");
	public static final Property INTERNAL_COVERAGE_FILE= getProp("intCovFile", internalBasePath.append("coverage.ec"));

	public static final Property INTERNAL_VERBOSITY_JVM_ARG= getProp("verbJvmArg", "-Demma.verbosity.level=");
	public static final Property INTERNAL_VERBOSITY_JVM_VALUE= getProp("verbJvmValue", "silent");

	public static final Property INTERNAL_META_FILE= getProp("intMetaFile", internalBasePath.append("coverage.em"));

	public static final Property INTERNAL_XML_REPORT= getProp("intXmlReport", internalBasePath.append("result.xml"));
	public static final Property INTERNAL_HTML_REPORT= getProp("intHtmlReport", internalBasePath.append("index.html"));
	/**
	 * Creates a new property
	 * 
	 * @param keyId the id of the key
	 * @param defaultValue the default value of the property
	 */
	private static final Property getProp(String keyId, Object defaultValue){
		return new Property(new QualifiedName(EmmaPlugin.ID, keyId), defaultValue);
	}
}
