/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Properties;
import com.vladium.emma.util.EmmaRunner;
import com.vladium.emma.util.ReportUtil;

public class BuildReportAction implements IObjectActionDelegate{
	public static final String HTML_REPORT_ID= "com|vladium|emma|action|buildHtmlReport";
	public static final String XML_REPORT_ID= "com|vladium|emma|action|buildXmlReport";
	public static final String TEXT_REPORT_ID= "com|vladium|emma|action|buildTextReport";

	private final Map selectedProjects= new HashMap();

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart){
		//Do nothing
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action){
		try{
			for(Iterator iter= selectedProjects.values().iterator(); iter.hasNext();){
				final IJavaProject javaProject= (IJavaProject)iter.next();
				final IProject project= javaProject.getProject();

				int type= -1;
				String outLocalPath= null;
				final String actionId= action.getId();
				if(actionId.equals(HTML_REPORT_ID)){
					type= EmmaRunner.HTML;
					outLocalPath= Properties.HTMLRESULT_ROOT.getPersistent(project);
				}else if(actionId.equals(XML_REPORT_ID)){
					type= EmmaRunner.XML;
					outLocalPath= Properties.XMLRESULT_ROOT.getPersistent(project);
				}else if(actionId.equals(TEXT_REPORT_ID)){
					type= EmmaRunner.TEXT;
					outLocalPath= Properties.TXTRESULT_ROOT.getPersistent(project);
				}

				ReportUtil.buildReport(javaProject, type, true, new Path(outLocalPath));

			}
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection){
		if(selection != null && selection instanceof IStructuredSelection){
			selectedProjects.clear();

			final IStructuredSelection ss= (IStructuredSelection)selection;
			for(Iterator iter= ss.iterator(); iter.hasNext();){
				final Object selected= iter.next();

				if(selected instanceof IJavaProject){
					final IJavaProject project= (IJavaProject)selected;

					selectedProjects.put(project.getProject().getName(), project);
				}
			}
		}
	}
}
