/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Messages;
import com.vladium.emma.Properties;
import com.vladium.emma.decorators.FilterDecorator;
import com.vladium.emma.joblisteners.AfterBuildJobListener;
import com.vladium.emma.util.BuildRunner;
import com.vladium.emma.util.EclipseFileUtil;

public class ChangeInstrumentedSetAction implements IObjectActionDelegate{
	public static final String REMOVEFILTER_ACTION_ID= "com|vladium|emma|removeFilterInstrumented";
	public static final String INCLUDE_ACTION_ID= "com|vladium|emma|includeInInstrumented";
	public static final String EXCLUDE_ACTION_ID= "com|vladium|emma|excludeFromInstrumented";

	private final Map selectedElements= new HashMap();

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart){
		//Do nothing
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action){
		try{
			//Set the new value				
			String newValue= null;
			final String actionId= action.getId();
			if(actionId.equals(INCLUDE_ACTION_ID)){
				newValue= Properties.INSTR_INCLUDE;
			}else if(actionId.equals(EXCLUDE_ACTION_ID)){
				newValue= Properties.INSTR_EXCLUDE;
			}

			final IResource[] resources= new IResource[selectedElements.size()];

			int pos= 0;
			for(Iterator iter= selectedElements.values().iterator(); iter.hasNext();){
				final IJavaElement element= (IJavaElement)iter.next();
				final IResource resource= element.getCorrespondingResource();

				Properties.IS_INSTRUMENTED.setPersistent(resource, newValue);

				final IProject project= element.getJavaProject().getProject();
				//Remove the meta data file so that it can be rebuilt
				final String metaFileName= Properties.INTERNAL_META_FILE.getPersistent(project);
				EclipseFileUtil.delete(project, metaFileName);

				//Rebuild project
				BuildRunner.startBuild(Messages.build_project_title + " " + project.getName(), project, new AfterBuildJobListener(project));

				resources[pos]= resource;
				pos++;
			}

			FilterDecorator.getInstance().refresh(resources);
		}catch(JavaModelException e){
			EmmaPlugin.log(e.getStatus());
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}
	}
	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection){
		try{
			if(selection != null && selection instanceof IStructuredSelection){
				selectedElements.clear();

				final IStructuredSelection ss= (IStructuredSelection)selection;
				for(Iterator iter= ss.iterator(); iter.hasNext();){
					final Object selected= iter.next();

					if(selected instanceof IJavaElement){
						final IJavaElement element= (IJavaElement)selected;

						final IResource resource= element.getCorrespondingResource();

						selectedElements.put(resource.getLocation(), element);

					}
				}
			}
		}catch(JavaModelException e){
			EmmaPlugin.log(e.getStatus());
		}
	}
}
