/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Properties;
import com.vladium.emma.util.EclipseFileUtil;
import com.vladium.emma.util.EmmaRunner;

public class InstrumentJarAction implements IObjectActionDelegate{
	private final Map selectedJars= new HashMap();

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart){
		//Do nothing
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action){
		if(!selectedJars.isEmpty()){
			try{
				IPath firstJarProjectLocation= null;
				IProject firstProject= null;
				String outFolder= null;

				//Build commands for Emma
				final List args= new ArrayList();

				for(Iterator iter= selectedJars.values().iterator(); iter.hasNext();){
					final IFile jarFile= (IFile)iter.next();

					final IProject project= jarFile.getProject();
					final IPath projectRoot= EclipseFileUtil.getAbsoluteLocation(project).addTrailingSeparator();

					if(firstProject == null){
						firstProject= project;
						firstJarProjectLocation= projectRoot;
						outFolder= Properties.INSTRUMENTED_ROOT.getPersistent(firstProject);
					}

					args.add("-instrpath");
					args.add(projectRoot.append(jarFile.getProjectRelativePath()).toOSString());
				}

				if(firstJarProjectLocation != null && firstProject != null){
					final IPath resultPath= firstJarProjectLocation.append(outFolder).addTrailingSeparator();

					args.add("-outdir");
					args.add(resultPath.toOSString());

					args.add("-outfile");
					args.add(resultPath.append("coverage.em").toOSString());

					args.add("-outmode");
					args.add("fullcopy");

					args.add("-merge");
					args.add("yes");

					args.add("-silent");

					new EmmaRunner(EmmaRunner.INSTR).runEmma(args);

					//Refresh output so that it shows in explorer
					firstProject.getFolder(outFolder).refreshLocal(0, null);
				}
			}catch(CoreException e){
				EmmaPlugin.log(e.getStatus());
			}
		}
	}
	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection){
		if(selection != null && selection instanceof IStructuredSelection){
			selectedJars.clear();

			final IStructuredSelection ss= (IStructuredSelection)selection;
			for(Iterator iter= ss.iterator(); iter.hasNext();){
				final Object selected= iter.next();

				if(selected instanceof IFile){
					final IFile jarFile= (IFile)selected;

					selectedJars.put(jarFile.getFullPath(), jarFile);
				}
			}
		}
	}
}
