/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Messages;
import com.vladium.emma.Properties;
import com.vladium.emma.joblisteners.AfterBuildJobListener;
import com.vladium.emma.util.BuildRunner;
import com.vladium.emma.util.DecorateUtil;
import com.vladium.emma.util.EclipseFileUtil;

public class ResetDataAction implements IObjectActionDelegate{
	private final Map selectedProjects= new HashMap();

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart){
		//Do nothing
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action){
		for(Iterator iter= selectedProjects.values().iterator(); iter.hasNext();){
			final IJavaProject javaProject= (IJavaProject)iter.next();
			final IProject project= javaProject.getProject();

			try{
				//Remove the coverage data file so that it can be rebuilt
				final String coverageFileName= Properties.INTERNAL_COVERAGE_FILE.getPersistent(project);
				EclipseFileUtil.delete(project, coverageFileName);

				//Remove the meta data file so that it can be rebuilt
				final String metaFileName= Properties.INTERNAL_META_FILE.getPersistent(project);
				EclipseFileUtil.delete(project, metaFileName);

				//Remove internal xml and html report
				final IPath internalXmlReport= (IPath)Properties.INTERNAL_XML_REPORT.getDefault();
				EclipseFileUtil.delete(project, internalXmlReport);

				//Remove internal xml and html report
				final IPath internalHtmlReport= (IPath)Properties.INTERNAL_HTML_REPORT.getDefault();
				EclipseFileUtil.delete(project, internalHtmlReport);
				final IPath reportRootFolder= internalHtmlReport.removeLastSegments(1).addTrailingSeparator();
				EclipseFileUtil.delete(project, reportRootFolder.append("_files"));

				DecorateUtil.redecorateCoverage(project, null);

				//Rebuild project
				BuildRunner.startBuild(Messages.build_project_title + " " + project.getName(), project, new AfterBuildJobListener(project));
			}catch(CoreException e){
				EmmaPlugin.log(e.getStatus());
			}
		}
	}
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection){
		if(selection != null && selection instanceof IStructuredSelection){
			selectedProjects.clear();

			final IStructuredSelection ss= (IStructuredSelection)selection;
			for(Iterator iter= ss.iterator(); iter.hasNext();){
				final Object selected= iter.next();

				if(selected instanceof IJavaProject){
					final IJavaProject project= (IJavaProject)selected;

					selectedProjects.put(project.getProject().getName(), project);
				}
			}
		}
	}
}