/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.builders;

import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MainBuilder extends IncrementalProjectBuilder{
	public static final String ID= "com.vladium.emma.MainBuilder";

	/**
	 * @see InternalBuilder#build(int, java.util.Map, IProgressMonitor)
	 */
	protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException{
		if(kind == IncrementalProjectBuilder.CLEAN_BUILD){
			fullBuild(monitor);
		}else{
			final IResourceDelta delta= getDelta(getProject());
			if(delta == null){
				fullBuild(monitor);
			}else{
				incrementalBuild(delta, monitor);
			}
		}
		return null;
	}

	/**
	 * Internal full builder
	 */
	private void fullBuild(final IProgressMonitor monitor) throws CoreException{
		getProject().accept(new MainVisitor());
	}

	/**
	 * Internal part builder
	 */
	private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException{
		delta.accept(new MainVisitor());
	}

	/**
	 * @see InternalBuilder#startupOnInitialize()
	 */
	protected void startupOnInitialize(){
		//No builder init logic exists
	}

	/**
	 * @see InternalBuilder#clean(org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void clean(IProgressMonitor monitor){
		//No builder clean logic exists
	}
}
