/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.decorators;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public abstract class BaseDecorator extends LabelProvider implements ILightweightLabelDecorator{
	/**
	 * The identifier for the label provider. Should return the name of the label
	 * provider specified in plugin.xml.
	 */
	public abstract String getId();

	/**
	 * Check if this decorator is enabled
	 */
	public boolean isEnabled(){
		final IDecoratorManager decoratorManager= PlatformUI.getWorkbench().getDecoratorManager();
		return decoratorManager.getEnabled(getId());
	}

	/**
	 * Blank full decorations refresh for all projects
	 */
	public void refresh(){
		if(isEnabled()){
			PlatformUI.getWorkbench().getDecoratorManager().update(getId());
		}
	}

	/**
	 * Refresh the specified resources
	 */
	public void refresh(IResource[] resourcesToBeUpdated){
		if(isEnabled()){
			fireLabelEvent(new LabelProviderChangedEvent(this, resourcesToBeUpdated));
		}
	}

	/**
	 * Fire a label change event so that the label decorators are refreshed.
	 */
	private void fireLabelEvent(final LabelProviderChangedEvent event){
		// We need to get the thread of execution to fire the label provider
		// changed event , else WSWB complains of thread exception. 
		Display.getDefault().asyncExec(new Runnable(){
			public void run(){
				fireLabelProviderChanged(event);
			}
		});
	}
}