/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.decorators;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.ui.IDecoratorManager;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Properties;
import com.vladium.emma.property.IPropertyChangeListener;
import com.vladium.emma.property.PropertyChangeEvent;

public class FilterDecorator extends BaseDecorator implements IPropertyChangeListener{
	//The same identifier as specified in the plugin.xml. Used throughout the code 
	//wherever the unique id is needed
	public static final String ID= "com|vladium|emma|decorators|filterDecorator";

	private String includedPrefix;
	private String excludedPrefix;

	/**
	 * Constructor
	 */
	public FilterDecorator(){
		final EmmaPlugin plugin= EmmaPlugin.getDefault();
		Properties.DECORATION_INCLUDED.addPropertyChangeListener(this);
		Properties.DECORATION_EXCLUDED.addPropertyChangeListener(this);

		includedPrefix= Properties.DECORATION_INCLUDED.getPersistent(plugin);
		excludedPrefix= Properties.DECORATION_EXCLUDED.getPersistent(plugin);
	}

	/*
	 * (non-Javadoc)
	 * @see com.vladium.emma.property.PropertyChangeListener#propertyChange(com.vladium.emma.property.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent event){
		if(event.sentFrom(Properties.DECORATION_INCLUDED)){
			includedPrefix= event.getNewValue().toString();
		}else if(event.sentFrom(Properties.DECORATION_EXCLUDED)){
			excludedPrefix= event.getNewValue().toString();
		}
	}

	/* (non-Javadoc)
	 * @see com.vladium.emma.decorators.BaseDecorator#getId()
	 */
	public String getId(){
		return ID;
	}

	public static FilterDecorator getInstance(){
		final IDecoratorManager decoratorManager= EmmaPlugin.getDefault().getWorkbench().getDecoratorManager();
		return (FilterDecorator)decoratorManager.getBaseLabelProvider(ID);
	}

	/**
	 * This method should only be called by the decorator thread.
	 * 
	 * @see org.eclipse.jface.viewers.ILightweightLabelDecorator#decorate(java.lang.Object, org.eclipse.jface.viewers.IDecoration)
	 */
	public void decorate(Object element, IDecoration decoration){
		try{
			if(element instanceof IResource){
				final IResource resource= (IResource)element;
				final IProject project= resource.getProject();

				if(resource.exists() && project.isOpen() && Properties.BUILDER_ENABLED.getPersistentAsBoolean(project)){
					final String isInstrumented= Properties.IS_INSTRUMENTED.getPersistent(resource);

					if(isInstrumented != null){
						if(isInstrumented.equals(Properties.INSTR_INCLUDE)){
							decoration.addPrefix(includedPrefix);
						}else if(isInstrumented.equals(Properties.INSTR_EXCLUDE)){
							decoration.addPrefix(excludedPrefix);
						}
					}
				}
			}
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}
	}
}