/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.joblisteners;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Properties;

/**
 * Listens for when a scheduled job finishes and updates created files, such as
 * the Emma meta file accordingly.
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2005-nov-03
 */
public class AfterBuildJobListener extends JobChangeAdapter{
	private IProject project;

	public AfterBuildJobListener(IProject project){
		this.project= project;
	}

	/**
	 * @see org.eclipse.core.runtime.jobs.IJobChangeListener#done(org.eclipse.core.runtime.jobs.IJobChangeEvent)
	 */
	public void done(IJobChangeEvent event){
		try{
			final String metaFile= Properties.INTERNAL_META_FILE.getPersistent(project);
			project.getFile(metaFile).refreshLocal(0, null);

			//Touch the coverage file. This will make coverage decorations be
			//rebuilt. Needed when a redecoration needs to be done when a user 
			//has changed the set of instrumented files
			final String coverageFilePath= Properties.INTERNAL_COVERAGE_FILE.getPersistent(project);
			final IFile coverageFile= project.getFile(coverageFilePath);
			if(coverageFile.exists()){
				coverageFile.touch(null);
			}
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}
	}
}
