/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.preferences;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Messages;
import com.vladium.emma.Properties;
import com.vladium.emma.decorators.CoverageDecorator;
import com.vladium.emma.decorators.FilterDecorator;
import com.vladium.emma.util.SwtUtil;

/**
 * The preferences page used to set decorations of the soruce files.
 */
public class PreferencesDecorationsPage extends PropertyPage implements IWorkbenchPreferencePage{
	private Text includePrefix;
	private Text excludePrefix;

	private Button packageClass;
	private Button packageMethod;
	private Button packageBlock;
	private Button packageLine;

	private Button sourceClass;
	private Button sourceMethod;
	private Button sourceBlock;
	private Button sourceLine;

	private Button nameDecorationActive;

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent){
		EmmaPlugin plugin= EmmaPlugin.getDefault();
		final Composite composite= new Composite(parent, SWT.NULL);
		final GridLayout layout= new GridLayout();
		layout.numColumns= 1;
		composite.setLayout(layout);

		final Group group= SwtUtil.createGridGroup(composite, Messages.preferences_filter_decorations, 5, -1);

		SwtUtil.createGridLabel(group, Messages.preferences_inc_decoration);
		includePrefix= SwtUtil.createGridTextField(group, Properties.DECORATION_INCLUDED.getPersistent(plugin), 30, -1);

		final Label label= SwtUtil.createGridLabel(group, Messages.preferences_exc_decoration);
		final GridData gd= new GridData();
		gd.horizontalIndent= 20;
		label.setLayoutData(gd);
		excludePrefix= SwtUtil.createGridTextField(group, Properties.DECORATION_EXCLUDED.getPersistent(plugin), 30, -1);

		final Group group2= SwtUtil.createGridGroup(composite, Messages.preferences_coverage_suffix, 3, 12);

		final Composite inner1= new Composite(group2, SWT.NULL);
		final GridLayout innerLayout1= new GridLayout();
		innerLayout1.numColumns= 1;
		inner1.setLayout(innerLayout1);

		SwtUtil.createGridLabel(inner1, Messages.preferences_coverage_package_header);
		packageClass= createCheckBox(inner1, Messages.preferences_coverage_class, Properties.PACKAGE_CLASS_FLAG.getPersistentAsBoolean(plugin));
		packageMethod= createCheckBox(inner1, Messages.preferences_coverage_method, Properties.PACKAGE_METHOD_FLAG.getPersistentAsBoolean(plugin));
		packageBlock= createCheckBox(inner1, Messages.preferences_coverage_block, Properties.PACKAGE_BLOCK_FLAG.getPersistentAsBoolean(plugin));
		packageLine= createCheckBox(inner1, Messages.preferences_coverage_line, Properties.PACKAGE_LINE_FLAG.getPersistentAsBoolean(plugin));

		SwtUtil.createVertGridSeparator(group2, 40, -1);

		final Composite inner2= new Composite(group2, SWT.NULL);
		final GridLayout innerLayout2= new GridLayout();
		innerLayout2.numColumns= 1;
		inner2.setLayout(innerLayout2);

		SwtUtil.createGridLabel(inner2, Messages.preferences_coverage_source_header);
		sourceClass= createCheckBox(inner2, Messages.preferences_coverage_class, Properties.SOURCE_CLASS_FLAG.getPersistentAsBoolean(plugin));
		sourceMethod= createCheckBox(inner2, Messages.preferences_coverage_method, Properties.SOURCE_METHOD_FLAG.getPersistentAsBoolean(plugin));
		sourceBlock= createCheckBox(inner2, Messages.preferences_coverage_block, Properties.SOURCE_BLOCK_FLAG.getPersistentAsBoolean(plugin));
		sourceLine= createCheckBox(inner2, Messages.preferences_coverage_line, Properties.SOURCE_LINE_FLAG.getPersistentAsBoolean(plugin));

		SwtUtil.createGridSeparator(group2, 7, 3);

		nameDecorationActive= new Button(group2, SWT.CHECK);
		final GridData gd2= new GridData();
		gd2.horizontalSpan= 3;
		gd2.verticalIndent= 7;
		nameDecorationActive.setLayoutData(gd2);
		nameDecorationActive.setSelection(Properties.NAME_DECORATION_ACTIVE.getPersistentAsBoolean(plugin));
		nameDecorationActive.setText(Messages.preferences_name_styling);

		return composite;
	}

	private Button createCheckBox(Composite parent, String text, boolean selected){
		final Button checkBox= new Button(parent, SWT.CHECK);
		final GridData gd= new GridData();
		gd.horizontalIndent= 5;
		checkBox.setLayoutData(gd);
		checkBox.setSelection(selected);
		checkBox.setText(text);
		return checkBox;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench){
		//Does nothing for now
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults(){
		final EmmaPlugin plugin= EmmaPlugin.getDefault();
		Properties.DECORATION_INCLUDED.setPersistent(plugin, null);
		includePrefix.setText(Properties.DECORATION_INCLUDED.getPersistent(plugin));

		Properties.DECORATION_EXCLUDED.setPersistent(plugin, null);
		excludePrefix.setText(Properties.DECORATION_EXCLUDED.getPersistent(plugin));

		Properties.PACKAGE_CLASS_FLAG.setPersistent(plugin, null);
		packageClass.setSelection(Properties.PACKAGE_CLASS_FLAG.getDefaultAsBoolean());
		Properties.PACKAGE_METHOD_FLAG.setPersistent(plugin, null);
		packageMethod.setSelection(Properties.PACKAGE_METHOD_FLAG.getDefaultAsBoolean());
		Properties.PACKAGE_BLOCK_FLAG.setPersistent(plugin, null);
		packageBlock.setSelection(Properties.PACKAGE_BLOCK_FLAG.getDefaultAsBoolean());
		Properties.PACKAGE_LINE_FLAG.setPersistent(plugin, null);
		packageLine.setSelection(Properties.PACKAGE_LINE_FLAG.getDefaultAsBoolean());

		Properties.SOURCE_CLASS_FLAG.setPersistent(plugin, null);
		sourceClass.setSelection(Properties.SOURCE_CLASS_FLAG.getDefaultAsBoolean());
		Properties.SOURCE_METHOD_FLAG.setPersistent(plugin, null);
		sourceMethod.setSelection(Properties.SOURCE_METHOD_FLAG.getDefaultAsBoolean());
		Properties.SOURCE_BLOCK_FLAG.setPersistent(plugin, null);
		sourceBlock.setSelection(Properties.SOURCE_BLOCK_FLAG.getDefaultAsBoolean());
		Properties.SOURCE_LINE_FLAG.setPersistent(plugin, null);
		sourceLine.setSelection(Properties.SOURCE_LINE_FLAG.getDefaultAsBoolean());

		nameDecorationActive.setSelection(Properties.NAME_DECORATION_ACTIVE.getDefaultAsBoolean());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	public boolean performOk(){
		final EmmaPlugin plugin= EmmaPlugin.getDefault();

		Properties.DECORATION_INCLUDED.setPersistent(plugin, includePrefix.getText());
		Properties.DECORATION_EXCLUDED.setPersistent(plugin, excludePrefix.getText());

		Properties.PACKAGE_CLASS_FLAG.setPersistent(plugin, packageClass.getSelection() + "");
		Properties.PACKAGE_METHOD_FLAG.setPersistent(plugin, packageMethod.getSelection() + "");
		Properties.PACKAGE_BLOCK_FLAG.setPersistent(plugin, packageBlock.getSelection() + "");
		Properties.PACKAGE_LINE_FLAG.setPersistent(plugin, packageLine.getSelection() + "");

		Properties.SOURCE_CLASS_FLAG.setPersistent(plugin, sourceClass.getSelection() + "");
		Properties.SOURCE_METHOD_FLAG.setPersistent(plugin, sourceMethod.getSelection() + "");
		Properties.SOURCE_BLOCK_FLAG.setPersistent(plugin, sourceBlock.getSelection() + "");
		Properties.SOURCE_LINE_FLAG.setPersistent(plugin, sourceLine.getSelection() + "");

		Properties.NAME_DECORATION_ACTIVE.setPersistent(plugin, nameDecorationActive.getSelection() + "");

		FilterDecorator.getInstance().refresh();
		CoverageDecorator.getInstance().refresh();

		return super.performOk();
	}
}