/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.properties;

import java.io.File;
import java.io.IOException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ui.dialogs.PropertyPage;

import com.vladium.emma.util.FileUtil;

/**
 * This class is used for common property page utils tasks, such as storing a 
 * persistant property for a project.
 * 
 * @author Erik Beijnoff
 * @since 2005-10-15
 */
public abstract class BasePropertyPage extends PropertyPage{
	/**
	 * Returns the project that the resource owning the properties page is invoked for
	 */
	protected IProject getProject(){
		IProject result= null;

		final Object element= getElement();
		if(element instanceof IResource){
			result= ((IResource)getElement()).getProject();
		}else if(element instanceof IJavaElement){
			result= ((IJavaElement)getElement()).getJavaProject().getProject();
		}
		return result;
	}

	protected byte[] getProjectFileContent(QualifiedName key) throws IOException{
		return FileUtil.getBytes(getProjectFile(key));
	}

	protected void setProjectFileContent(QualifiedName key, byte[] content) throws IOException{
		FileUtil.writeToFile(getProjectFile(key), content);
	}

	private File getProjectFile(QualifiedName key){
		final String path= key.getQualifier();
		final String fileName= key.getLocalName();
		return getProject().getWorkingLocation(path).append(fileName).toFile();
	}
}