/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Messages;
import com.vladium.emma.Properties;
import com.vladium.emma.joblisteners.AfterBuildJobListener;
import com.vladium.emma.util.BuildRunner;
import com.vladium.emma.util.EclipseFileUtil;

/**
 * The page where project specific settings are done. This is where the plugin is 
 * activated on a project basis.
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2005-okt-03 
 */
public class ProjectPropertyCoveragePage extends BasePropertyPage{
	private Button incRegExButton;
	private Button excRegExButton;

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent){
		final Composite composite= new Composite(parent, SWT.NULL);
		final GridLayout gridLayout= new GridLayout();
		gridLayout.numColumns= 1;
		composite.setLayout(gridLayout);

		createLabel(composite, Messages.properties_filter_desc1, -1);

		final Label separator= new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
		final GridData sepGd= new GridData(GridData.FILL_HORIZONTAL);
		separator.setLayoutData(sepGd);

		createLabel(composite, Messages.properties_filter_desc2, -1);
		createLabel(composite, Messages.properties_filter_desc3, -1);

		final Label separator2= new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
		final GridData sepGd2= new GridData(GridData.FILL_HORIZONTAL);
		sepGd2.verticalIndent= 12;
		separator2.setLayoutData(sepGd2);

		createLabel(composite, Messages.properties_filter_incpatterns, -1);
		try{
			// Enablement of regular expression support for filters
			incRegExButton= new Button(composite, SWT.CHECK);
			incRegExButton.setSelection(Properties.INCLUDE_FILTER_IS_REGEX.getPersistentAsBoolean(getProject()));
			incRegExButton.setText(Messages.properties_filter_regexenabled);

			final Label separator3= new Label(composite, SWT.SEPARATOR | SWT.HORIZONTAL);
			final GridData sepGd3= new GridData(GridData.FILL_HORIZONTAL);
			sepGd3.verticalIndent= 12;
			separator3.setLayoutData(sepGd3);
			//Exclusion filters
			createLabel(composite, Messages.properties_filter_excpatterns, -1);

			// Enablement of regular expression support for filters
			excRegExButton= new Button(composite, SWT.CHECK);
			excRegExButton.setSelection(Properties.EXCLUDE_FILTER_IS_REGEX.getPersistentAsBoolean(getProject()));
			excRegExButton.setText(Messages.properties_filter_regexenabled);
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}
		return composite;
	}
	protected Label createLabel(Composite parent, String text, int verticalIndent){
		final Label label= new Label(parent, SWT.WRAP);
		final GridData gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint= 200;
		if(verticalIndent != -1){
			gd.verticalIndent= verticalIndent;
		}
		label.setLayoutData(gd);
		label.setText(text);
		return label;
	}

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults(){
		incRegExButton.setSelection(Properties.INCLUDE_FILTER_IS_REGEX.getDefaultAsBoolean());

		excRegExButton.setSelection(Properties.EXCLUDE_FILTER_IS_REGEX.getDefaultAsBoolean());
	}

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk(){
		try{
			final IProject project= getProject();

			Properties.INCLUDE_FILTER_IS_REGEX.setPersistent(project, incRegExButton.getSelection() + "");
			Properties.EXCLUDE_FILTER_IS_REGEX.setPersistent(project, excRegExButton.getSelection() + "");

			EmmaPlugin.getDefault().clearProjectFilter(project);

			//Remove the meta data file so that it can be rebuilt
			final String metaFileName= Properties.INTERNAL_META_FILE.getPersistent(project);
			EclipseFileUtil.delete(project, metaFileName);

			//Rebuild project
			BuildRunner.startBuild(Messages.build_project_title + " " + project.getName(), project, new AfterBuildJobListener(project));
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}

		return true;
	}
}