/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Messages;
import com.vladium.emma.Properties;
import com.vladium.emma.util.SwtUtil;

/**
 * The page where project specific settings are done. This is where the plugin is 
 * activated on a project basis.
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2005-okt-03
 */
public class ProjectPropertyOutputPage extends BasePropertyPage{
	private Text instrumentedDir;
	private Text htmlReportFile;
	private Text xmlReportFile;
	private Text txtReportFile;

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent){
		final IProject project= getProject();

		final Composite composite= new Composite(parent, SWT.NULL);
		final GridLayout gridLayout= new GridLayout();
		gridLayout.numColumns= 2;
		gridLayout.verticalSpacing= 7;
		composite.setLayout(gridLayout);

		try{
			//Instrumented jars output path
			SwtUtil.createGridLabel(composite, Messages.instrumented_output_dir, -1, -1, 2);

			instrumentedDir= SwtUtil.createGridTextField(composite, Properties.INSTRUMENTED_ROOT.getPersistent(project), -1, 2);

			//Separator		
			SwtUtil.createGridSeparator(composite, 12, 2);

			//Output label
			SwtUtil.createGridLabel(composite, Messages.output_report, -1, -1, 2);

			//Html			
			SwtUtil.createGridLabel(composite, Messages.output_report_html);
			htmlReportFile= SwtUtil.createGridTextField(composite, Properties.HTMLRESULT_ROOT.getPersistent(project), -1, -1);

			//Xml
			SwtUtil.createGridLabel(composite, Messages.output_report_xml);
			xmlReportFile= SwtUtil.createGridTextField(composite, Properties.XMLRESULT_ROOT.getPersistent(project), -1, -1);

			//Text			
			SwtUtil.createGridLabel(composite, Messages.output_report_txt);
			txtReportFile= SwtUtil.createGridTextField(composite, Properties.TXTRESULT_ROOT.getPersistent(project), -1, -1);
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
			return null;
		}
		return composite;
	}

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults(){
		htmlReportFile.setText(Properties.HTMLRESULT_ROOT.getDefaultAsString());
		xmlReportFile.setText(Properties.XMLRESULT_ROOT.getDefaultAsString());
		txtReportFile.setText(Properties.TXTRESULT_ROOT.getDefaultAsString());
		instrumentedDir.setText(Properties.INSTRUMENTED_ROOT.getDefaultAsString());
	}
	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk(){
		try{
			final IProject project= getProject();

			Properties.INSTRUMENTED_ROOT.setPersistent(project, instrumentedDir.getText());
			Properties.HTMLRESULT_ROOT.setPersistent(project, htmlReportFile.getText());
			Properties.XMLRESULT_ROOT.setPersistent(project, xmlReportFile.getText());
			Properties.TXTRESULT_ROOT.setPersistent(project, txtReportFile.getText());
		}catch(CoreException e){
			EmmaPlugin.log(e.getStatus());
		}
		return true;
	}
}