/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.properties;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Messages;
import com.vladium.emma.swtcomponents.IInputValidator;

/**
 * Implementation of the IInputValidator interface for regular expression verification
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2005-nov-08
 */
public class RegExValidator implements IInputValidator{
	private final Button regExEnabledButton;

	public RegExValidator(Button enabledButton){
		this.regExEnabledButton= enabledButton;
	}

	/*
	 * (non-Javadoc)
	 * @see com.vladium.emma.swtcomponents.IInputValidator#validate(java.lang.String)
	 */
	public boolean validate(String value){
		boolean validates= true;

		if(regExEnabledButton.getSelection()){
			try{
				Pattern.compile(value);
			}catch(PatternSyntaxException e){
				MessageDialog.openError(EmmaPlugin.getActiveShell(), Messages.regexerror_title, Messages.regexerror_desc + e.getMessage());
				validates= false;
			}
		}

		return validates;
	}
}
