/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.property;

public class PropertyChangeEvent{
	private Property property;
	private Object trigger;
	private Object oldValue;
	private Object newValue;

	/**
	 * Constructor
	 * 
	 * @param property the property the event is originating from
	 */
	public PropertyChangeEvent(Property property, Object trigger, Object oldvalue, Object newValue){
		this.property= property;
		this.trigger= trigger;
		this.oldValue= oldvalue;
		this.newValue= newValue;
	}

	public boolean sentFrom(Property testAgainst){
		return property.getKey().equals(testAgainst.getKey());
	}

	public Property getProperty(){
		return property;
	}

	public Object getTrigger(){
		return trigger;
	}

	public Object getOldValue(){
		return oldValue;
	}

	public String getOldValueAsString(){
		return oldValue == null ? null : oldValue.toString();
	}

	public Object getNewValue(){
		return newValue;
	}

	public String getNewValueAsString(){
		return newValue == null ? null : newValue.toString();
	}

	public boolean getNewValueAsBoolean(){
		return new Boolean(getNewValueAsString()).booleanValue();
	}
}