/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.report;

/**
 * Container class to hold coverage information about a package or a class.
 * 
 * @author Erik Beijnoff erik@beijnoff.com
 * @since 2005-nov-14
 */
public class CoverageData{
	public static final int UNSET= -1;

	private int classCoverage= UNSET;
	private int methodCoverage= UNSET;
	private int blockCoverage= UNSET;
	private int lineCoverage= UNSET;

	private String packageName;
	private String className;

	/**
	 * Constructor
	 * 
	 * @param packageName the name of the package the data belongs to
	 * @param className the name of the class the data belongs to
	 */
	public CoverageData(String packageName, String className){
		this.packageName= packageName;
		this.className= className;
	}

	public String getClassName(){
		return className;
	}

	public String getPackageName(){
		return packageName;
	}

	public int getClassCoverage(){
		return classCoverage;
	}
	void setClassCoverage(int classCoverage){
		this.classCoverage= classCoverage;
	}
	public int getMethodCoverage(){
		return methodCoverage;
	}
	void setMethodCoverage(int methodCoverage){
		this.methodCoverage= methodCoverage;
	}
	public int getBlockCoverage(){
		return blockCoverage;
	}
	void setBlockCoverage(int blockCoverage){
		this.blockCoverage= blockCoverage;
	}
	public int getLineCoverage(){
		return lineCoverage;
	}
	void setLineCoverage(int lineCoverage){
		this.lineCoverage= lineCoverage;
	}
}