/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.IPath;

import com.vladium.emma.Command;

public class EmmaRunner{
	//Constants for all available commands
	public static final String EMMARUN= "emmarun";
	public static final String INSTR= "instr";
	public static final String MERGE= "merge";
	public static final String REPORT= "report";

	//All avaliable commands
	public static final Set COMMANDS;
	static{
		Set tmp= new HashSet();
		tmp.add(EMMARUN);
		tmp.add(INSTR);
		tmp.add(MERGE);
		tmp.add(REPORT);

		COMMANDS= tmp;
	}

	//Constants for shortcut report method
	public static final int HTML= 0;
	public static final int XML= 1;
	public static final int TEXT= 2;

	private final String commandName;

	/**
	 * Constructor
	 * 
	 * @param command the command to execute
	 */
	public EmmaRunner(String commandName){
		if(!COMMANDS.contains(commandName)){
			throw new IllegalArgumentException("Emma can only be run with the commands that are declared " + "as constants in the EmmaRunner class.");
		}

		this.commandName= commandName;
	}

	/**
	 * The main method used to execute Emma
	 * 
	 * @param args the list of arguments that are given to Emma
	 */
	public void runEmma(List args){
		final Command command= Command.create(commandName, "emma ".concat(commandName), (String[])args.toArray(new String[args.size()]));
		command.run();
	}

	/**
	 * Shortcut method used to execute a report build
	 */
	public static void runReport(int reportType, IPath outPath, IPath metaFile, IPath coverageFile, IPath[] sourcePaths){
		final EmmaRunner runner= new EmmaRunner(EmmaRunner.REPORT);

		//Build commands for Emma			
		final List args= new ArrayList();
		args.add("-input");
		args.add(metaFile.toOSString());

		args.add("-input");
		args.add(coverageFile.toOSString());

		String type= null;
		String outFile= null;
		final String outSystemPath= outPath.toOSString();
		if(reportType == HTML){
			type= "html";
			outFile= "-Dreport.html.out.file=" + outSystemPath;
		}else if(reportType == XML){
			type= "xml";
			outFile= "-Dreport.xml.out.file=" + outSystemPath;
		}else if(reportType == TEXT){
			type= "txt";
			outFile= "-Dreport.txt.out.file=" + outSystemPath;
		}

		args.add("-report");
		args.add(type);
		args.add(outFile);

		args.add("-silent");

		if(sourcePaths != null){
			for(int i= 0; i < sourcePaths.length; i++){
				args.add("-sourcepath");
				args.add(sourcePaths[i].toOSString());
			}
		}

		runner.runEmma(args);
	}
}
