/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

import com.vladium.emma.EmmaPlugin;
import com.vladium.emma.Properties;
import com.vladium.emma.filter.Filter;

/**
 * This class is used for common File handling tasks
 * 
 * @author Erik Beijnoff
 * @since 2002-09-15
 */
public class FilterUtil{
	/** Hidden constructor */
	private FilterUtil(){
		//This object can not be instantiated
	}

	/**
	 * Checks if a resource is included according to the filtering rules for Emma
	 */
	public static boolean isIncluded(IJavaElement element) throws CoreException{
		boolean isIncluded= true;

		String instrInPath= null;
		IJavaElement tmpElement= element;
		while(tmpElement != null && tmpElement.exists() && tmpElement.getElementType() != IJavaElement.PACKAGE_FRAGMENT_ROOT){
			if(instrInPath == null){
				instrInPath= Properties.IS_INSTRUMENTED.getPersistent(tmpElement.getCorrespondingResource());
			}
			tmpElement= tmpElement.getParent();
		}

		if(instrInPath != null){
			if(instrInPath.equals(Properties.INSTR_EXCLUDE)){
				isIncluded= false;
			}
		}else{
			String fullName= null;
			if(element instanceof ICompilationUnit){
				final IType type= ((ICompilationUnit)element).findPrimaryType();
				fullName= type.getFullyQualifiedName();
			}else if(element instanceof IPackageFragment){
				fullName= ((IPackageFragment)element).getElementName();
			}

			if(fullName != null){
				final IProject project= element.getJavaProject().getProject();
				final Filter filter= EmmaPlugin.getDefault().getProjectFilter(project);
				isIncluded= filter.matches(fullName);
			}
		}

		return isIncluded;
	}
}