/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

/**
 * This class is used for common eclipse java project manipulation tasks.
 * 
 * @author Erik Beijnoff
 * @since 2002-09-15
 */
public class JavaProjectUtil{
	/** Hidden constructor */
	private JavaProjectUtil(){
		//This object can not be instantiated
	}

	/**
	 * Returns all roots from a java project of the specified type. 
	 * 
	 * @param javaProject the project to find roots for
	 * @param type constant type for example @link org.eclipse.jdt.core.IPackageFragmentRoot#K_SOURCE
	 */
	public static IPackageFragmentRoot[] getRootsOfType(IJavaProject javaProject, int kind) throws JavaModelException{
		final IPackageFragmentRoot[] packageRoots= javaProject.getPackageFragmentRoots();
		final List rootList= new ArrayList();
		for(int i= 0; i < packageRoots.length; i++){
			if(packageRoots[i].getKind() == kind){
				rootList.add(packageRoots[i]);
			}
		}

		return (IPackageFragmentRoot[])rootList.toArray(new IPackageFragmentRoot[rootList.size()]);
	}
}