/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import java.util.regex.Pattern;

public class SemiRegExConverter{
	/** Hidden constructor */
	private SemiRegExConverter(){
		//This object can not be instantiated
	}

	/**
	 * This is a helper method to convert a semi regular expression 
	 * into the full equivalent regular expression pattern. A semi regular expression
	 * here is a text string that may contain * and ? as vildcards but no other 
	 * regular expression character. The string is converted into a string
	 * that can be feeded into the @link java.util.regex.Pattern#compile(java.lang.String)
	 * method. <br/><br/>
	 * 
	 * Example: <br/>
	 * "*tmp" -&gt; ".*\Qtmp\E"
	 * "a wo?d" -&gt; "\Qa wo\E.?\Qd\E""
	 * *tmp*hel.lo?te\Ext" -> ".*\Qtmp\E.*\Qhel.lo\E.?\Qte\E\\E\Qxt\E"
	 * 
	 * @param quasiRegEx the expression to convert.
	 */
	public static Pattern createRegExFromSemi(String semiRegEx){
		StringBuffer sb= new StringBuffer();

		final String[] firstSplit= semiRegEx.split("\\*", -1);
		for(int i= 0; i < firstSplit.length; i++){
			final String first= firstSplit[i];

			if(!first.equals("")){
				final String[] secondSplit= first.split("\\?", -1);

				for(int j= 0; j < secondSplit.length; j++){
					final String second= secondSplit[j];

					if(!second.equals("")){
						final String[] thirdSplit= second.split("\\\\E", -1);

						for(int k= 0; k < thirdSplit.length; k++){
							final String third= thirdSplit[k];

							if(!third.equals("")){
								sb.append("\\Q");
								sb.append(third);
								sb.append("\\E");
							}

							if(k != thirdSplit.length - 1){
								sb.append("\\\\E");
							}
						}
					}

					if(j != secondSplit.length - 1){
						sb.append(".");
					}
				}
			}

			if(i != firstSplit.length - 1){
				sb.append(".*");
			}
		}

		return Pattern.compile(sb.toString());
	}
}