/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * A class for common string InputStream handling tasks
 * 
 * @author Erik Beijnoff
 * @since 2002-12-13
 */
public class StreamUtil{
	/** Hidden constructor */
	private StreamUtil(){
		//This object can not be instantiated
	}

	/**
	 * Parses the content of a stream into a String
	 * 
	 * @param is the InputStream to read from
	 * @return the parsed String
	 */
	public static String getString(final InputStream in) throws IOException{
		final String ls= System.getProperty("line.separator");

		final StringBuffer sb= new StringBuffer(10000);
		final BufferedReader reader= new BufferedReader(new InputStreamReader(in));

		String parseLine;
		try{
			boolean isFirst= true;
			while((parseLine= reader.readLine()) != null){
				if(!isFirst){
					sb.append(ls);
				}
				sb.append(parseLine);

				isFirst= false;
			}
		}finally{
			in.close();
		}

		return sb.toString();
	}
}