/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.filter;

import junit.framework.TestCase;

public class FilterTest extends TestCase{
	public void testEmpty(){
		final Filter filter= new Filter();
		assertTrue(filter.matches(""));
		assertTrue(filter.matches("one"));
		assertTrue(filter.matches("1"));
		assertTrue(filter.matches("*"));
	}

	public void testInclusionAll(){
		final Filter filter= new Filter();
		filter.addInclusion(".*");

		assertTrue(filter.matches(""));
		assertTrue(filter.matches("one"));
		assertTrue(filter.matches("1"));
		assertTrue(filter.matches("*"));
		assertTrue(filter.matches("***"));
	}

	public void testInclusion(){
		final Filter filter= new Filter();
		filter.addInclusion("hello");

		assertFalse(filter.matches(""));
		assertFalse(filter.matches("two"));
		assertFalse(filter.matches("1"));
		assertTrue(filter.matches("hello"));
		assertFalse(filter.matches("shello"));
	}

	public void testIncRemoval(){
		final Filter filter= new Filter();
		filter.addInclusion("hello");
		filter.removeInclusion("hello");

		assertTrue(filter.matches("anything 1"));
	}

	public void testExclusion(){
		final Filter filter= new Filter();
		filter.addExclusion("hello");

		assertTrue(filter.matches(""));
		assertTrue(filter.matches("two"));
		assertTrue(filter.matches("1"));
		assertFalse(filter.matches("hello"));
		assertTrue(filter.matches("shello"));
	}

	public void testExcRemoval(){
		final Filter filter= new Filter();
		filter.addExclusion("hello");
		filter.removeExclusion("hello");

		assertTrue(filter.matches("hello"));
	}

	public void testIncExc(){
		final Filter filter= new Filter();
		filter.addInclusion(".+");
		filter.addExclusion("hello");

		assertFalse(filter.matches(""));
		assertTrue(filter.matches("1"));
		assertTrue(filter.matches("a"));
		assertTrue(filter.matches("1a"));
		assertFalse(filter.matches("hello"));
	}

	public void testComplexIncExc(){
		final Filter filter= new Filter();
		filter.addInclusion("[^n-o]{2}text[0-9]+");
		filter.addExclusion("aatext1");
		filter.addExclusion("wrong");
		filter.addExclusion(".{12}");

		assertFalse(filter.matches(""));
		assertFalse(filter.matches("a"));
		assertFalse(filter.matches("b"));

		assertTrue(filter.matches("abtext1"));
		assertFalse(filter.matches("aatext1"));
		assertFalse(filter.matches("antext1"));

		assertFalse(filter.matches("wrong"));
		assertTrue(filter.matches("abtext11111"));
		assertFalse(filter.matches("abtext111112"));
	}
}