/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import junit.framework.TestCase;

public class ExceptionUtilTest extends TestCase{
	public void testExceptionUtil(){
		assertEquals(ExceptionUtil.getPosition(), "ExceptionUtilTest.testExceptionUtil()");

		assertEquals(ExceptionUtil.getFullPosition(), "com.vladium.emma.util.ExceptionUtilTest.testExceptionUtil()");
	}

	public void testExceptionUtil2(){
		assertEquals(ExceptionUtil.getPosition(0), "ExceptionUtilTest.testExceptionUtil2()");
	}

	public void testExceptionUtil3(){
		assertEquals(ExceptionUtil.getCommonMessage(new Exception()), "ExceptionUtilTest.testExceptionUtil3(), " + "an exception of type java.lang.Exception occured: null");
	}

	public void testExceptionUtil4(){
		try{
			ExceptionUtil.throwAsRuntime(new IllegalArgumentException("Hello"));
			fail("This should not be reached");
		}catch(Exception e){
			assertEquals("ExceptionUtilTest.testExceptionUtil4(), an exception of type " + "java.lang.IllegalArgumentException occured: Hello", e.getMessage());
		}
	}
}