/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.util;

import junit.framework.TestCase;

public class SemiRegExConverterTest extends TestCase{
	public void testCreateRegExFromQuasi(){
		assertEquals("", SemiRegExConverter.createRegExFromSemi("").pattern());
		assertEquals("\\Qtest\\E", SemiRegExConverter.createRegExFromSemi("test").pattern());

		assertEquals(".*", SemiRegExConverter.createRegExFromSemi("*").pattern());
		assertEquals(".*\\Qhello\\E", SemiRegExConverter.createRegExFromSemi("*hello").pattern());
		assertEquals(".*\\Qt\\E", SemiRegExConverter.createRegExFromSemi("*t").pattern());
		assertEquals("\\Qt\\E.*", SemiRegExConverter.createRegExFromSemi("t*").pattern());
		assertEquals(".*\\Qt\\E.*", SemiRegExConverter.createRegExFromSemi("*t*").pattern());
		assertEquals(".*\\Qt\\E.*\\Qe\\E", SemiRegExConverter.createRegExFromSemi("*t*e").pattern());

		assertEquals(".", SemiRegExConverter.createRegExFromSemi("?").pattern());
		assertEquals(".\\Qhello\\E", SemiRegExConverter.createRegExFromSemi("?hello").pattern());
		assertEquals(".\\Qt\\E", SemiRegExConverter.createRegExFromSemi("?t").pattern());
		assertEquals("\\Qt\\E.", SemiRegExConverter.createRegExFromSemi("t?").pattern());
		assertEquals(".\\Qt\\E.", SemiRegExConverter.createRegExFromSemi("?t?").pattern());
		assertEquals(".\\Qt\\E.\\Qe\\E", SemiRegExConverter.createRegExFromSemi("?t?e").pattern());

		assertEquals(".*.", SemiRegExConverter.createRegExFromSemi("*?").pattern());
		assertEquals(".*..*", SemiRegExConverter.createRegExFromSemi("*?*").pattern());
		assertEquals("..*.", SemiRegExConverter.createRegExFromSemi("?*?").pattern());
		assertEquals(".\\Qt2\\E.*", SemiRegExConverter.createRegExFromSemi("?t2*").pattern());
		assertEquals(".\\Qt2\\E.*\\Qt3\\E.", SemiRegExConverter.createRegExFromSemi("?t2*t3?").pattern());

		assertEquals("\\\\E", SemiRegExConverter.createRegExFromSemi("\\E").pattern());
		assertEquals("\\Qtest\\E\\\\E\\Qt\\E", SemiRegExConverter.createRegExFromSemi("test\\Et").pattern());
		assertEquals(".*\\\\E", SemiRegExConverter.createRegExFromSemi("*\\E").pattern());
		assertEquals(".*.\\\\E", SemiRegExConverter.createRegExFromSemi("*?\\E").pattern());
		assertEquals("\\Qte\\E\\\\E\\\\E\\Qtata\\E\\\\E\\Qta\\E", SemiRegExConverter.createRegExFromSemi("te\\E\\Etata\\Eta").pattern());
	}

	public void testAppliedCreatedRegEx(){
		String test1= "*";
		assertTrue(SemiRegExConverter.createRegExFromSemi(test1).matcher("").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test1).matcher("one").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test1).matcher("\\E").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test1).matcher("*").matches());

		String test2= "com.**";
		assertTrue(SemiRegExConverter.createRegExFromSemi(test2).matcher("com.lasse").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test2).matcher("com.hello").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test2).matcher("commando").matches());

		String test3= "*.test.*";
		assertTrue(SemiRegExConverter.createRegExFromSemi(test3).matcher("com.test.hello").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test3).matcher("ett.test.hello").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test3).matcher("com.testf.hello").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test3).matcher(".test").matches());

		String test4= "?";
		assertTrue(SemiRegExConverter.createRegExFromSemi(test4).matcher(".").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test4).matcher("a").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test4).matcher("ab").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test4).matcher(".abc").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test4).matcher("").matches());

		String test5= "?.test.*.tmp";
		assertTrue(SemiRegExConverter.createRegExFromSemi(test5).matcher("a.test.df.tmp").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test5).matcher("b.test.df.tmp").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test5).matcher("aa.test.df.tmp").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test5).matcher(".abc").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test5).matcher("").matches());

		String test6= "?\\E.com";
		assertTrue(SemiRegExConverter.createRegExFromSemi(test6).matcher("a\\E.com").matches());
		assertTrue(SemiRegExConverter.createRegExFromSemi(test6).matcher("b\\E.com").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test6).matcher("aa\\E.com").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test6).matcher("a.\\.com").matches());
		assertTrue(!SemiRegExConverter.createRegExFromSemi(test6).matcher("a\\\\E.co").matches());
	}
}