/* Copyright (C) 2005 Felipe Leme. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.test;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;

/**
 * This is the base class for test cases that manipulate Java-nature projects.
 * It provides the plumbing for setting up a Java project in the workspace.
 * 
 * @author Felipe Leme <emma@felipeal.net>
 *
 */
public abstract class AbstractJavaProjectTestCase extends AbstractProjectTestCase {
  
  /** fixture representing the project used for the test */
  protected IJavaProject fJavaProject;  
  
  protected AbstractJavaProjectTestCase( String testName ) throws Exception {
    super( testName );
  }  
  
  /*
   *  (non-Javadoc)
   * @see com.vladium.emma.test.AbstractWorkspaceTestCase#createTestFixture()
   */
  protected void createTestFixture() throws CoreException {
    super.createTestFixture();
    this.fJavaProject = JDTHelper.createJavaProject( super.fProject );
  }

}
