/* Copyright (C) 2005 Felipe Leme. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.test;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;

/**
 * This is the base class for test cases that manipulate generic projects.
 * It provides the plumbing for setting up a project in the workspace.
 * 
 * @author Felipe Leme <emma@felipeal.net>
 *
 */
public abstract class AbstractProjectTestCase extends AbstractWorkspaceTestCase {

  /** default name for the project that will be created*/
  protected static final String UNNAMED_PROJECT = "UnnamedProject";
  
  /** reference to a generic project */
  protected IProject fProject;    
  
  /**
   * Default constructor.
   * @param testName name of the testcase being tested
   * @throws Exception never thrown here, but declared so sub-classes can throw
   */
  protected AbstractProjectTestCase( String testName ) throws Exception {
    super( testName );
  }
    
  /*
   *  (non-Javadoc)
   * @see com.vladium.emma.test.AbstractWorkspaceTestCase#createTestFixture()
   */
  protected void createTestFixture() throws CoreException {
    final IWorkspaceRoot root = this.fWorkspace.getRoot();
    this.fProject = root.getProject( UNNAMED_PROJECT );
    this.fProject.create( null );
    this.fProject.open( null );
  } 
  
  /*
   *  (non-Javadoc)
   * @see com.vladium.emma.test.AbstractWorkspaceTestCase#disposeTestFixture()
   */
  protected void disposeTestFixture( ) throws CoreException {
    this.fProject.delete( true, true, null );
  }

}
