/* Copyright (C) 2005 Felipe Leme. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.test;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/**
 * Helper class for JDT-related functions.
 * 
 * @author Felipe Leme <emma@felipeal.net>
 * 
 */
public final class JDTHelper {
  
  /* 
   * Class just provide static methods
   */
  private JDTHelper() {
	  //Hidden constructor
  }
  
  /**
   * Create and open a Java project.
   * @return an open Java project
   * @throws CoreException propagated
   */
  public static IJavaProject createJavaProject( IProject project ) throws CoreException {
    final IJavaProject javaProject = JavaCore.create( project );
    setJavaNature( project );
    javaProject.open( null );
    return javaProject;
  }  
  
  /**
   * Set a project's nature to Java 
   * @param project project to be set
   * @throws CoreException propagated.
   */
  public static void setJavaNature( IProject project ) throws CoreException {
    final IProjectDescription description = project.getDescription();
    final String javaNature = JavaCore.NATURE_ID;
    description.setNatureIds( new String[] { javaNature } );
    // getDescription() returns a clone, so we need to set it back
    project.setDescription( description, null );
  }
  

}
