/* Copyright (C) 2005 Erik Beijnoff. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */
package com.vladium.emma.test;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;

import com.vladium.emma.test.util.TestProject;

/**
 * Used to set up a default workspace environment for tests. Contains several projects 
 * in different states which in turn contain a hierarchy of source files etc. that the 
 * tests can manipulate.
 * 
 * @author Erik Beijnoff <erik@beijnoff.com>
 * 
 * TODO - Create a project that is external to the workbench that in turn has a source folder
 * 		  and an output folder set as symbolic links
 */
public abstract class StandardFixtureTestCase extends AbstractWorkspaceTestCase{
	protected TestProject internalProject;
	//protected TestProject externalProject;
	protected TestProject closedProject;

	/**
	 * Constructor
	 */
	protected StandardFixtureTestCase(String testName) throws Exception{
		super(testName);
	}

	/*
	 *  (non-Javadoc)
	 * @see com.vladium.emma.test.AbstractWorkspaceTestCase#createFixture()
	 */
	protected void createTestFixture() throws CoreException{
		internalProject= new TestProject("Internal project", "bin", "src");

		createPackage(internalProject, "helpers", new String[]{"BaseClass.java"});

		createPackage(internalProject, "various", new String[]{"Coverage75Percent.java", "Coverage92Percent.java"});

		createPackage(internalProject, "", new String[]{"One.java", "Two.java", "Three.java"});
		createPackage(internalProject, "com", new String[]{"One.java", "Two.java", "Three.java"});
		createPackage(internalProject, "com.subpackage", new String[]{"One.java", "Two.java", "Three.java"});

		closedProject= new TestProject("Closed project", "bin", "src");
		closedProject.getJavaProject().getProject().close(null);
	}

	private void createPackage(TestProject project, String packageName, String[] sourceNames) throws CoreException{
		final IPackageFragment pack= project.createPackage(packageName);
		for(int i= 0; i < sourceNames.length; i++){
			final String sourceName= sourceNames[i];
			final InputStream in= getClass().getResourceAsStream(sourceName + ".txt");
			final String content= inputStreamToString(in);

			project.createCompilationUnit(pack, sourceName, content);
		}
	}

	private String inputStreamToString(InputStream in){
		final StringBuffer sb= new StringBuffer();
		try{
			final byte[] b= new byte[4096];
			for(int n= 0; (n= in.read(b)) != -1;){
				sb.append(new String(b, 0, n));
			}
		}catch(IOException e){
			throw new RuntimeException("An error occured while reading file: " + e.getMessage(), e);
		}
		return sb.toString();
	}

	/*
	 *  (non-Javadoc)
	 * @see com.vladium.emma.test.AbstractWorkspaceTestCase#disposeFixture()
	 */
	protected void disposeTestFixture() throws CoreException{
		internalProject.dispose();
		//externalProject.dispose();
		closedProject.dispose();
	}
}