/* Copyright (C) 2005 Felipe Leme. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */

package com.vladium.emma.test;

import org.eclipse.core.runtime.CoreException;

/**
 * Test cases for the AbstractJavaProjectTestCase.
 *
 * @author Felipe Leme <emma@felipeal.net>
 *
 */
public class AbstractJavaProjectTest extends AbstractJavaProjectTestCase {

  public AbstractJavaProjectTest( String testName ) throws Exception {
    super( testName );
  }
  
  public void testGetJavaProject() {
    assertNotNull( "java project is null", super.fJavaProject );
  }
  
  public void testJavaProjectIsOpen() {
    final boolean isOpen = super.fJavaProject.isOpen();
    assertTrue( "java project is closed", isOpen );
  }
  
  public void testDispose() throws CoreException {    
    super.disposeTestFixture();
    final boolean isJavaOpen = super.fJavaProject.isOpen();
    assertFalse( "java project is still open", isJavaOpen );
  }

}
