/* Copyright (C) 2005 Felipe Leme. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 */

package com.vladium.emma.test;

import org.eclipse.core.runtime.CoreException;

/**
 * Test cases for the AbstractProjectTestCase.
 *
 * @author Felipe Leme <emma@felipeal.net>
 *
 */
public class AbstractProjectTest extends AbstractProjectTestCase {

  public AbstractProjectTest( String testName ) throws Exception {
    super( testName );
  }
  
  public void testGetProject() {
    assertNotNull( "project is null", super.fProject );
  }
  
  public void testProjectIsOpen() {
    final boolean isOpen = super.fProject.isOpen();
    assertTrue( "project is closed", isOpen );
  }
  
  public void testDispose() throws CoreException {    
    super.disposeTestFixture();
    final boolean isOpen = super.fProject.isOpen();
    assertFalse( "project is still open", isOpen );
  }
  

}
